/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.eventlistener;

import com.github.bingoohuang.blackcat.server.base.BlackcatReqListener;
import com.github.bingoohuang.blackcat.server.dao.BlackcatConfig;
import com.github.bingoohuang.blackcat.server.dao.EventDao;
import com.github.bingoohuang.blackcat.server.domain.BlackcatConfigBean;
import com.github.bingoohuang.blackcat.server.domain.BlackcatMetricReq;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.util.Calendar;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlackcatMetricReqListener
implements BlackcatReqListener {
    @Autowired
    EventDao eventDao;
    @Autowired
    BlackcatConfigBean bean;
    Map<String, Long> divbases = Maps.newHashMap();

    @PostConstruct
    public void postConstruct() {
        for (BlackcatConfig.ConfigMetric configMetric : this.bean.getConfigMetrics()) {
            this.divbases.put(configMetric.getName(), configMetric.getDivbase());
        }
    }

    public long getDivBase(String metricName) {
        return this.divbases.containsKey(metricName) ? this.divbases.get(metricName) : 3600L;
    }

    @Subscribe
    public void deal(BlackcatMetricReq req) {
        long divBase = this.getDivBase(req.getName());
        long millis = req.getTs();
        long millisFromMidnight = BlackcatMetricReqListener.getMillisFromMidnight(millis);
        req.setSeq(millisFromMidnight / 1000L / divBase);
        this.eventDao.addEventMetric(req);
    }

    public static long getMillisFromMidnight(long millis) {
        Calendar m = Calendar.getInstance();
        m.setTimeInMillis(millis);
        m.set(11, 0);
        m.set(12, 0);
        m.set(13, 0);
        m.set(14, 0);
        return millis - m.getTimeInMillis();
    }
}

