/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.job;

import com.github.bingoohuang.blackcat.sdk.utils.Blackcats;
import com.github.bingoohuang.blackcat.sdk.utils.StrBuilder;
import com.github.bingoohuang.blackcat.server.base.BlackcatJob;
import com.github.bingoohuang.blackcat.server.base.MsgService;
import com.github.bingoohuang.blackcat.server.base.QuartzScheduler;
import com.github.bingoohuang.blackcat.server.domain.BlackcatConfigBean;
import java.util.concurrent.ConcurrentMap;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HeartbeatJob
implements BlackcatJob {
    @Autowired
    MsgService msgService;
    @Autowired
    BlackcatConfigBean configBean;

    @Override
    public void scheduleJob(QuartzScheduler scheduler) {
        if (this.configBean.getConfigHostnames().isEmpty()) {
            return;
        }
        JobDetail heartbeatJob = this.createHeartbeatJobDetail();
        Trigger heartbeatTrigger = this.createHeartbeatTrigger();
        scheduler.scheduleJob(heartbeatJob, heartbeatTrigger);
    }

    private JobDetail createHeartbeatJobDetail() {
        JobDetail job = JobBuilder.newJob(HeartbeatQuartzJob.class).build();
        job.getJobDataMap().put("handler", (Object)this);
        return job;
    }

    private Trigger createHeartbeatTrigger() {
        return TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(1).repeatForever()).startAt(DateBuilder.futureDate((int)70, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).build();
    }

    private void checkHeartbeats() {
        StrBuilder msg = new StrBuilder();
        ConcurrentMap<String, Long> beats = this.configBean.getBeats();
        for (String hostname : this.configBean.getConfigHostnames()) {
            Long lastBeat = (Long)beats.get(hostname);
            if (this.isLastBeatInOneHalfMinute(lastBeat)) continue;
            msg.p("\n").p(hostname);
            if (lastBeat == null) {
                msg.p("\u6ca1\u6709\u68c0\u6d4b\u5230\u5fc3\u8df3");
                continue;
            }
            msg.p("\u4e0a\u6b21\u5fc3\u8df3").p(Blackcats.format((long)lastBeat)).p("\u57281\u5206\u534a\u524d");
        }
        if (msg.len() == 0) {
            return;
        }
        this.msgService.sendMsg("\u670d\u52a1\u5668\u5fc3\u8df3\u544a\u8b66", msg.toString());
    }

    private boolean isLastBeatInOneHalfMinute(Long lastBeat) {
        if (lastBeat == null) {
            return false;
        }
        return System.currentTimeMillis() - lastBeat <= 90000L;
    }

    public static class HeartbeatQuartzJob
    implements Job {
        public void execute(JobExecutionContext context) {
            JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
            HeartbeatJob handler = (HeartbeatJob)jobDataMap.get((Object)"handler");
            handler.checkHeartbeats();
        }
    }
}

