/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.cqler;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class ClusterFactory {
    static LoadingCache<String, Cluster> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Cluster>(){

        public Cluster load(String clusterName) throws Exception {
            return ClusterFactory.load(clusterName);
        }
    });

    public static Cluster getCluster(String clusterName) {
        return (Cluster)cache.getUnchecked((Object)clusterName);
    }

    private static Cluster load(String clusterName) throws Exception {
        PoolingOptions poolingOptions = new PoolingOptions();
        poolingOptions.setCoreConnectionsPerHost(HostDistance.LOCAL, 4).setMaxConnectionsPerHost(HostDistance.LOCAL, 10).setCoreConnectionsPerHost(HostDistance.REMOTE, 2).setMaxConnectionsPerHost(HostDistance.REMOTE, 4);
        Properties properties = ClusterFactory.loadClasspathPropertiesFile("cqler/" + clusterName + ".properties");
        String contactPoints = properties.getProperty("contactPoints", "127.0.0.1");
        Splitter splitter = Splitter.onPattern((String)"\\s+").omitEmptyStrings().trimResults();
        List contactPointList = splitter.splitToList((CharSequence)contactPoints);
        String port = properties.getProperty("port", "9042");
        return Cluster.builder().addContactPoints(contactPointList.toArray(new String[0])).withPort(Integer.parseInt(port)).withPoolingOptions(poolingOptions).build();
    }

    public static Properties loadClasspathPropertiesFile(String propertiesFile) {
        Properties properties = new Properties();
        try {
            ClassLoader classLoader = ClusterFactory.class.getClassLoader();
            InputStream is = classLoader.getResourceAsStream(propertiesFile);
            if (is == null) {
                throw new RuntimeException("property file " + propertiesFile + " does not exit");
            }
            properties.load(is);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return properties;
    }
}

