/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.cqler.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;

public class CqlParser {
    static Pattern seqParamPlaceholder = Pattern.compile("#(\\d+?)#");
    static Pattern attrParamPlaceholder = Pattern.compile("#(\\S+?)#");
    final String cql;
    final Object[] args;

    public CqlParser(String cql, Object[] args) {
        this.cql = cql;
        this.args = args;
    }

    public CqlParserResult parseCql() throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (this.cql.contains("##")) {
            return this.parseAutoParams();
        }
        if (seqParamPlaceholder.matcher(this.cql).find()) {
            return this.parseSeqParams();
        }
        return this.parseAttrParams();
    }

    private CqlParserResult parseSeqParams() {
        Matcher matcher = seqParamPlaceholder.matcher(this.cql);
        if (!matcher.find()) {
            return new CqlParserResult(this.cql, new Object[0]);
        }
        ArrayList<Integer> seqs = new ArrayList<Integer>();
        int pos = 0;
        while (matcher.find(pos)) {
            String seqNum = matcher.group(1);
            seqs.add(Integer.parseInt(seqNum));
            pos = matcher.end();
        }
        Object[] bindParams = new Object[seqs.size()];
        for (int i = 0; i < seqs.size(); ++i) {
            bindParams[i] = this.args[(Integer)seqs.get(i) - 1];
        }
        String execSql = matcher.replaceAll("?");
        return new CqlParserResult(execSql, bindParams);
    }

    private CqlParserResult parseAttrParams() throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Matcher matcher = attrParamPlaceholder.matcher(this.cql);
        ArrayList<Object> attrSeqs = new ArrayList<Object>();
        int pos = 0;
        while (matcher.find(pos)) {
            String seqNum = matcher.group(1);
            attrSeqs.add(PropertyUtils.getProperty((Object)this.args[0], (String)seqNum));
            pos = matcher.end();
        }
        String execSql = matcher.replaceAll("?");
        Object[] objects = new Object[attrSeqs.size()];
        for (int i = 0; i < attrSeqs.size(); ++i) {
            objects[i] = attrSeqs.get(i);
        }
        return new CqlParserResult(execSql, objects);
    }

    private CqlParserResult parseAutoParams() {
        String execSql = this.cql.replaceAll("##", "?");
        return new CqlParserResult(execSql, this.args);
    }

    static class CqlParserResult {
        public final Object[] bindParams;
        public final String execSql;

        public CqlParserResult(String execSql, Object[] bindParams) {
            this.execSql = execSql;
            this.bindParams = bindParams;
        }
    }
}

