/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.cqler.spring;

import com.github.bingoohuang.cqler.annotations.Cqler;
import com.github.bingoohuang.cqler.spring.CqlerFactoryBean;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassPathCqlerScanner
extends ClassPathBeanDefinitionScanner {
    public ClassPathCqlerScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
    }

    public void registerFilters() {
        this.addExcludeFilter(new TypeFilter(){

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                return !metadataReader.getClassMetadata().isInterface();
            }
        });
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Cqler.class));
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            this.logger.warn((Object)("No cqler was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration."));
        } else {
            for (BeanDefinitionHolder holder : beanDefinitions) {
                GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Creating CqlerFactoryBean with name '" + holder.getBeanName() + "' and '" + definition.getBeanClassName() + "' cqlerInterface"));
                }
                definition.getPropertyValues().add("cqlerInterface", (Object)definition.getBeanClassName());
                definition.setBeanClass(CqlerFactoryBean.class);
            }
        }
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) throws IllegalStateException {
        if (super.checkCandidate(beanName, beanDefinition)) {
            return true;
        }
        this.logger.warn((Object)("Skipping CqlerFactoryBean with name '" + beanName + "' and '" + beanDefinition.getBeanClassName() + "' cqlerInterface. Bean already defined with the same name!"));
        return false;
    }
}

