/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.cqler.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.github.bingoohuang.cqler.ClusterFactory;
import com.github.bingoohuang.cqler.annotations.Cql;
import com.github.bingoohuang.cqler.annotations.Cqler;
import com.github.bingoohuang.cqler.impl.CqlParser;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlInvocationHandler
implements InvocationHandler {
    Logger logger = LoggerFactory.getLogger(CqlInvocationHandler.class);
    static Cache<String, PreparedStatement> preparedCache = CacheBuilder.newBuilder().build();

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        return this.executeCql(method, args);
    }

    private Object executeCql(Method method, Object[] args) throws Exception {
        Class<?> hostClass = method.getDeclaringClass();
        Cqler cqlerAnn = hostClass.getAnnotation(Cqler.class);
        String keyspace = cqlerAnn.keyspace();
        String clusterName = cqlerAnn.cluster();
        Cluster cluster = ClusterFactory.getCluster(clusterName);
        Cql cqlAnn = method.getAnnotation(Cql.class);
        String cql = cqlAnn.value();
        if (this.isKeyspaceDdl(cql)) {
            this.execCqlDirectly(cluster, cql);
            return null;
        }
        if (this.isQuery(cql)) {
            return this.executeQuery(method, cluster, keyspace, cql, args);
        }
        return this.executeOthers(cluster, keyspace, cql, args);
    }

    private Object executeOthers(Cluster cluster, String keyspace, String cql, Object[] args) throws Exception {
        try (Session session = cluster.connect(keyspace);){
            CqlParser.CqlParserResult parserResult = new CqlParser(cql, args).parseCql();
            BoundStatement boundStatement = this.bindParams(session, parserResult);
            ResultSet resultSet = session.execute((Statement)boundStatement);
        }
        catch (Exception e) {
            this.logger.error("execute {} failed", (Object)cql, (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
        return null;
    }

    private Object executeQuery(Method method, Cluster cluster, String keyspace, String cql, Object[] args) throws Exception {
        List<Map> result;
        try (Session session = cluster.connect(keyspace);){
            CqlParser.CqlParserResult parserResult = new CqlParser(cql, args).parseCql();
            BoundStatement boundStatement = this.bindParams(session, parserResult);
            ResultSet resultSet = session.execute((Statement)boundStatement);
            result = this.getResultMaps(resultSet);
        }
        if (Collection.class.isAssignableFrom(method.getReturnType())) {
            return this.parseCollectionResult(method, result);
        }
        if (result.isEmpty()) {
            return null;
        }
        if (method.getReturnType() == Map.class) {
            return this.parseMapResult(method, result);
        }
        Map map = result.get(0);
        if (map == null) {
            return null;
        }
        if (this.isBasicDataTypes(method.getReturnType())) {
            return this.parseBaseDataTypeResult(method, map);
        }
        Object obj = method.getReturnType().newInstance();
        this.map2Bean(map, obj);
        return obj;
    }

    private void execCqlDirectly(Cluster cluster, String cql) {
        try (Session session = cluster.connect();){
            this.logger.debug("execute cql : {}", (Object)cql);
            session.execute(cql);
        }
    }

    private Object parseBaseDataTypeResult(Method method, Map map) throws ParseException {
        Class<?> returnType = method.getReturnType();
        Object o = new Object();
        for (Object key : map.keySet()) {
            o = map.get(key);
        }
        if (returnType == Integer.TYPE) {
            return o == null ? null : Integer.valueOf(Integer.parseInt(o.toString()));
        }
        if (returnType == Byte.TYPE) {
            return o == null ? null : Byte.valueOf(Byte.parseByte(o.toString()));
        }
        if (returnType == Short.TYPE) {
            return o == null ? null : Short.valueOf(Short.parseShort(o.toString()));
        }
        if (returnType == Long.TYPE) {
            return o == null ? null : Long.valueOf(Long.parseLong(o.toString()));
        }
        if (returnType == Double.TYPE) {
            return o == null ? null : Double.valueOf(Double.parseDouble(o.toString()));
        }
        if (returnType == Float.TYPE) {
            return o == null ? null : Float.valueOf(Float.parseFloat(o.toString()));
        }
        if (returnType == Boolean.TYPE) {
            return o == null ? null : Boolean.valueOf(Boolean.parseBoolean(o.toString()));
        }
        if (returnType == Long.class) {
            return Long.valueOf(o.toString());
        }
        if (returnType == Date.class) {
            Date date = (Date)o;
            return date;
        }
        return o;
    }

    private Object parseMapResult(Method method, List<Map> result) {
        Iterator<Map> iterator = result.iterator();
        if (iterator.hasNext()) {
            Map map = iterator.next();
            return map;
        }
        return null;
    }

    private Object parseCollectionResult(Method method, List<Map> result) throws Exception {
        if (method.getReturnType() == List.class) {
            return this.getListResult(method, result);
        }
        return result;
    }

    private Object getListResult(Method method, List<Map> result) throws Exception {
        ArrayList listResult = Lists.newArrayList();
        if (!ParameterizedType.class.isAssignableFrom(method.getGenericReturnType().getClass())) {
            this.parseNoParadigmResult(result, listResult);
            return listResult;
        }
        ParameterizedType pt = (ParameterizedType)method.getGenericReturnType();
        Type[] actualTypeArguments = pt.getActualTypeArguments();
        Class actualArgClass = (Class)actualTypeArguments[0];
        if (this.parseBasicDataTypeResult(result, listResult, actualArgClass)) {
            return listResult;
        }
        return this.parseCommonBeanResult(result, listResult, actualArgClass);
    }

    private Object parseCommonBeanResult(List<Map> result, List listResult, Class<?> aClass) throws Exception {
        for (Map map : result) {
            Object obj = aClass.newInstance();
            this.map2Bean(map, obj);
            listResult.add(obj);
        }
        return listResult;
    }

    private boolean parseBasicDataTypeResult(List<Map> result, List listResult, Class<?> aClass) {
        if (this.isBasicDataTypes(aClass)) {
            this.parseNoParadigmResult(result, listResult);
            return true;
        }
        return false;
    }

    private void parseNoParadigmResult(List<Map> result, List listResult) {
        for (Map map : result) {
            for (Object key : map.keySet()) {
                listResult.add(map.get(key));
            }
        }
    }

    private List<Map> getResultMaps(ResultSet resultSet) {
        ArrayList result = Lists.newArrayList();
        for (Row row : resultSet) {
            HashMap map = Maps.newHashMap();
            result.add(map);
            int ii = resultSet.getColumnDefinitions().size();
            for (int i = 0; i < ii; ++i) {
                String key = resultSet.getColumnDefinitions().getName(i).toLowerCase().replaceAll("_", "");
                map.put(key, row.getObject(i));
            }
        }
        return result;
    }

    public BoundStatement bindParams(Session session, CqlParser.CqlParserResult cqlParserResult) {
        PreparedStatement ps = CqlInvocationHandler.prepareCql(session, cqlParserResult);
        BoundStatement boundStatement = new BoundStatement(ps);
        this.logger.debug("execute cql {} with params: {}", (Object)cqlParserResult.execSql, (Object)cqlParserResult.bindParams);
        boundStatement.bind(cqlParserResult.bindParams);
        return boundStatement;
    }

    private static PreparedStatement prepareCql(final Session session, final CqlParser.CqlParserResult cqlParserResult) {
        try {
            return (PreparedStatement)preparedCache.get((Object)cqlParserResult.execSql, (Callable)new Callable<PreparedStatement>(){

                @Override
                public PreparedStatement call() throws Exception {
                    return session.prepare(cqlParserResult.execSql);
                }
            });
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private void map2Bean(Map map, Object obj) throws Exception {
        PropertyDescriptor[] propertyDescriptors;
        BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
        for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            String propertyName;
            Method setter = property.getWriteMethod();
            if (setter == null || map.get(propertyName = property.getName().toLowerCase()) == null) continue;
            setter.invoke(obj, map.get(property.getName().toLowerCase()));
        }
    }

    private boolean isQuery(String cql) {
        String lowerCaseCql = cql.toLowerCase();
        return lowerCaseCql.startsWith("select");
    }

    private boolean isKeyspaceDdl(String cql) {
        String lowerCaseCql = cql.toLowerCase();
        return lowerCaseCql.startsWith("create keyspace") || lowerCaseCql.startsWith("drop keyspace") || lowerCaseCql.startsWith("alter keyspace");
    }

    private boolean isBasicDataTypes(Class<?> clazz) {
        return clazz == Integer.TYPE || clazz == Character.TYPE || clazz == Short.TYPE || clazz == Byte.TYPE || clazz == Long.TYPE || clazz == Double.TYPE || clazz == Float.TYPE || clazz == Boolean.TYPE || clazz == String.class || clazz == Date.class || clazz == Long.class;
    }
}

