/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.patchca.custom;

import com.github.bingoohuang.patchca.random.RandUtils;
import com.github.bingoohuang.patchca.word.WordBean;
import com.github.bingoohuang.patchca.word.WordFactory;

public class MathArithmeticFactory
implements WordFactory {
    private static String[] chineseNumber = new String[]{"\u96f6", "\u4e00\u58f9\u3220\u2460\u2474", "\u4e8c\u3221\u8d30\u2461\u2475", "\u4e09\u3222\u53c1\u2462\u2476", "\u56db\u3223\u8086\u2463\u2477", "\u4e94\u3224\u4f0d\u2464\u2478", "\u516d\u3225\u9646\u2465\u2479", "\u4e03\u3226\u67d2\u2466\u247a", "\u516b\u3227\u634c\u2467\u247b", "\u4e5d\u3228\u7396\u2468\u247c", "\u5341\u3229\u62fe\u2469\u247d", "\u767e\u4f70", "\u5343\u4edf", "\u4e07"};
    private static String[] operations = new String[]{"\u52a0+", "\u51cf", "\u4e58X", "\u9664\u00f7"};

    public static String rand(int n) {
        if (n > 9) {
            return "" + n;
        }
        String s1 = chineseNumber[n];
        char c1 = s1.charAt(RandUtils.randInt(s1.length()));
        return "" + c1;
    }

    @Override
    public WordBean getNextWord() {
        int n1 = RandUtils.randInt(9) + 1;
        int n2 = RandUtils.randInt(9) + 1;
        String rand1 = MathArithmeticFactory.rand(n1);
        String rand2 = MathArithmeticFactory.rand(n2);
        String randMin = MathArithmeticFactory.rand(Math.min(n1, n2));
        String randMax = MathArithmeticFactory.rand(Math.max(n1, n2));
        String rand12 = MathArithmeticFactory.rand(n1 * n2);
        int op = RandUtils.randInt(4);
        String opStr = operations[op];
        char opCh = opStr.charAt(RandUtils.randInt(opStr.length()));
        int expected = 0;
        String result = "";
        int askPos = RandUtils.randInt(3);
        if (op == 0) {
            if (askPos == 0) {
                expected = Math.abs(n1 - n2);
                result = "?" + opCh + randMin + '=' + randMax;
            } else if (askPos == 1) {
                expected = Math.abs(n1 - n2);
                result = randMin + opCh + "?=" + randMax;
            } else if (askPos == 2) {
                expected = n1 + n2;
                result = rand1 + opCh + rand2 + "=?";
            }
        } else if (op == 1) {
            if (askPos == 0) {
                expected = n1 + n2;
                result = "?" + opCh + rand1 + '=' + rand2;
            } else if (askPos == 1) {
                expected = Math.abs(n1 - n2);
                result = randMax + opCh + "?=" + randMin;
            } else if (askPos == 2) {
                expected = Math.abs(n1 - n2);
                result = randMax + opCh + randMin + "=?";
            }
        } else if (op == 2) {
            if (askPos == 0) {
                expected = n2;
                result = "?" + opCh + rand1 + '=' + rand12;
            } else if (askPos == 1) {
                expected = n2;
                result = rand1 + opCh + "?=" + rand12;
            } else if (askPos == 2) {
                expected = n2 * n1;
                result = rand1 + opCh + rand2 + "=?";
            }
        } else if (op == 3) {
            if (askPos == 0) {
                expected = n2 * n1;
                result = "?" + opCh + rand1 + '=' + rand2;
            } else if (askPos == 1) {
                expected = n2;
                result = rand12 + opCh + "?=" + rand1;
            } else if (askPos == 2) {
                expected = n2;
                result = rand12 + opCh + rand1 + "=?";
            }
        }
        return new WordBean(result, "" + expected, "\u8bf7\u8f93\u5165\u56fe\u7247\u4e2d?\u4ee3\u8868\u7684\u6570\u5b57");
    }

    @Override
    public String[] getSupportedFontFamilies() {
        return new String[]{"\u5b8b\u4f53"};
    }
}

