/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.patchca.random;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

class GB2312Unicode {
    static OutputStream out = null;
    static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static int[] b_out = new int[]{201, 267, 279, 293, 484, 587, 625, 657, 734, 782, 827, 874, 901, 980, 5590};
    static int[] e_out = new int[]{216, 268, 280, 294, 494, 594, 632, 694, 748, 794, 836, 894, 903, 994, 5594};

    GB2312Unicode() {
    }

    public static void main(String[] args) {
        try {
            out = new FileOutputStream("gb2312.gb");
            GB2312Unicode.writeCode();
            out.close();
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    public static void writeCode() throws IOException {
        boolean reserved = false;
        String name = null;
        CharsetDecoder gbdc = Charset.forName("GBK").newDecoder();
        CharsetEncoder uxec = Charset.forName("UTF-16BE").newEncoder();
        CharsetEncoder u8ec = Charset.forName("UTF-8").newEncoder();
        ByteBuffer gbbb = null;
        ByteBuffer uxbb = null;
        ByteBuffer u8bb = null;
        CharBuffer cb = null;
        int count = 0;
        for (int i = 1; i <= 94; ++i) {
            if (i >= 1 && i <= 9) {
                reserved = false;
                name = "Graphic symbols";
            } else if (i >= 10 && i <= 15) {
                reserved = true;
                name = "Reserved";
            } else if (i >= 16 && i <= 55) {
                reserved = false;
                name = "Level 1 characters";
            } else if (i >= 56 && i <= 87) {
                reserved = false;
                name = "Level 2 characters";
            } else if (i >= 88 && i <= 94) {
                reserved = true;
                name = "Reserved";
            }
            GB2312Unicode.writeln();
            GB2312Unicode.writeString("<p>");
            GB2312Unicode.writeNumber(i);
            GB2312Unicode.writeString(" Row: " + name);
            GB2312Unicode.writeln();
            GB2312Unicode.writeString("</p>");
            GB2312Unicode.writeln();
            if (reserved) continue;
            GB2312Unicode.writeln();
            GB2312Unicode.writeHeader();
            for (int j = 1; j <= 94; ++j) {
                byte hi = (byte)(160 + i);
                byte lo = (byte)(160 + j);
                if (GB2312Unicode.validGB(i, j)) {
                    gbbb = ByteBuffer.wrap(new byte[]{hi, lo});
                    if (i >= 16 && i <= 55) {
                        String str = new String(new byte[]{hi, lo}, "GBK");
                        System.out.println(str);
                    }
                    try {
                        cb = gbdc.decode(gbbb);
                        uxbb = uxec.encode(cb);
                        cb.rewind();
                        u8bb = u8ec.encode(cb);
                    }
                    catch (CharacterCodingException e) {
                        cb = null;
                        uxbb = null;
                        u8bb = null;
                    }
                } else {
                    cb = null;
                    uxbb = null;
                    u8bb = null;
                }
                GB2312Unicode.writeNumber(i);
                GB2312Unicode.writeNumber(j);
                GB2312Unicode.writeString(" ");
                if (cb != null) {
                    GB2312Unicode.writeByte(hi);
                    GB2312Unicode.writeByte(lo);
                    GB2312Unicode.writeString(" ");
                    GB2312Unicode.writeHex(hi);
                    GB2312Unicode.writeHex(lo);
                    ++count;
                } else {
                    GB2312Unicode.writeGBSpace();
                    GB2312Unicode.writeString(" null");
                }
                GB2312Unicode.writeString(" ");
                GB2312Unicode.writeByteBuffer(uxbb, 2);
                GB2312Unicode.writeString(" ");
                GB2312Unicode.writeByteBuffer(u8bb, 3);
                if (j % 2 == 0) {
                    GB2312Unicode.writeln();
                    continue;
                }
                GB2312Unicode.writeString("   ");
            }
            GB2312Unicode.writeFooter();
        }
        System.out.println("Number of GB characters wrote: " + count);
    }

    public static void writeln() throws IOException {
        out.write(13);
        out.write(10);
    }

    public static void writeByte(byte b) throws IOException {
        out.write(b & 0xFF);
    }

    public static void writeByteBuffer(ByteBuffer b, int l) throws IOException {
        int i = 0;
        if (b == null) {
            GB2312Unicode.writeString("null");
            i = 2;
        } else {
            for (i = 0; i < b.limit(); ++i) {
                GB2312Unicode.writeHex(b.get(i));
            }
        }
        for (int j = i; j < l; ++j) {
            GB2312Unicode.writeString("  ");
        }
    }

    public static void writeGBSpace() throws IOException {
        out.write(161);
        out.write(161);
    }

    public static void writeString(String s) throws IOException {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                out.write(s.charAt(i) & 0xFF);
            }
        }
    }

    public static void writeNumber(int i) throws IOException {
        String s = "00" + String.valueOf(i);
        GB2312Unicode.writeString(s.substring(s.length() - 2, s.length()));
    }

    public static void writeHex(byte b) throws IOException {
        out.write(hexDigit[b >> 4 & 0xF]);
        out.write(hexDigit[b & 0xF]);
    }

    public static void writeHeader() throws IOException {
        GB2312Unicode.writeString("<pre>");
        GB2312Unicode.writeln();
        GB2312Unicode.writeString("Q.W. ");
        GB2312Unicode.writeGBSpace();
        GB2312Unicode.writeString(" GB   Uni. UTF-8 ");
        GB2312Unicode.writeString("   ");
        GB2312Unicode.writeString("Q.W. ");
        GB2312Unicode.writeGBSpace();
        GB2312Unicode.writeString(" GB   Uni. UTF-8 ");
        GB2312Unicode.writeln();
        GB2312Unicode.writeln();
    }

    public static void writeFooter() throws IOException {
        GB2312Unicode.writeString("</pre>");
        GB2312Unicode.writeln();
    }

    public static boolean validGB(int i, int j) {
        for (int l = 0; l < b_out.length; ++l) {
            if (i * 100 + j < b_out[l] || i * 100 + j > e_out[l]) continue;
            return false;
        }
        return true;
    }
}

