/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.patchca.random;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class SpellUtils {
    public static String getFull(String src) {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        format.setVCharType(HanyuPinyinVCharType.WITH_V);
        StringBuilder pinyin = new StringBuilder();
        try {
            for (char element : src.toCharArray()) {
                if (Character.toString(element).matches("[\\u4E00-\\u9FA5]+")) {
                    String[] srcArry = PinyinHelper.toHanyuPinyinStringArray((char)element, (HanyuPinyinOutputFormat)format);
                    pinyin.append(srcArry[0]);
                    continue;
                }
                pinyin.append(Character.toString(element));
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
            // empty catch block
        }
        return pinyin.toString();
    }

    public static String getFirst(String str) {
        StringBuilder pinyin = new StringBuilder();
        for (char word : str.toCharArray()) {
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            if (pinyinArray != null) {
                pinyin.append(pinyinArray[0].charAt(0));
                continue;
            }
            pinyin.append(word);
        }
        return pinyin.toString();
    }
}

