/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.patchca.service;

import com.github.bingoohuang.patchca.background.BackgroundFactory;
import com.github.bingoohuang.patchca.color.ColorFactory;
import com.github.bingoohuang.patchca.filter.FilterFactory;
import com.github.bingoohuang.patchca.font.FontFactory;
import com.github.bingoohuang.patchca.service.Captcha;
import com.github.bingoohuang.patchca.service.CaptchaService;
import com.github.bingoohuang.patchca.text.renderer.TextRenderer;
import com.github.bingoohuang.patchca.word.WordBean;
import com.github.bingoohuang.patchca.word.WordFactory;
import java.awt.image.BufferedImage;

public abstract class AbstractCaptchaService
implements CaptchaService {
    protected FontFactory fontFactory;
    protected WordFactory wordFactory;
    protected ColorFactory colorFactory;
    protected BackgroundFactory backgroundFactory;
    protected TextRenderer textRenderer;
    protected FilterFactory filterFactory;
    protected int width;
    protected int height;

    public void setFontFactory(FontFactory fontFactory) {
        this.fontFactory = fontFactory;
    }

    public void setWordFactory(WordFactory wordFactory) {
        this.wordFactory = wordFactory;
    }

    public void setColorFactory(ColorFactory colorFactory) {
        this.colorFactory = colorFactory;
    }

    public void setBackgroundFactory(BackgroundFactory backgroundFactory) {
        this.backgroundFactory = backgroundFactory;
    }

    public void setTextRenderer(TextRenderer textRenderer) {
        this.textRenderer = textRenderer;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public FontFactory getFontFactory() {
        return this.fontFactory;
    }

    public WordFactory getWordFactory() {
        return this.wordFactory;
    }

    public ColorFactory getColorFactory() {
        return this.colorFactory;
    }

    public BackgroundFactory getBackgroundFactory() {
        return this.backgroundFactory;
    }

    public TextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public FilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public Captcha getCaptcha() {
        BufferedImage bufImage = new BufferedImage(this.width, this.height, 2);
        this.backgroundFactory.fillBackground(bufImage);
        WordBean wordBean = this.wordFactory.getNextWord();
        this.fontFactory.setWord(wordBean.getWord());
        this.textRenderer.draw(wordBean.getWord(), bufImage, this.fontFactory, this.colorFactory);
        bufImage = this.filterFactory.applyFilters(bufImage);
        return new Captcha(wordBean.getWord(), wordBean.getAnswer(), bufImage, wordBean.getTips());
    }
}

