/*
 * Decompiled with CFR 0.152.
 */
package com.github.biticcf.mountain.shackle;

import com.github.biticcf.mountain.core.common.service.WdServiceCallback;
import com.github.biticcf.mountain.shackle.DomainTemplate;
import com.github.biticcf.mountain.shackle.MethodMetadata;
import com.github.biticcf.mountain.shackle.Shackle;
import com.github.biticcf.mountain.shackle.ShackleDomain;
import com.github.biticcf.mountain.shackle.Types;
import com.github.biticcf.mountain.shackle.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public interface Contract {
    public List<MethodMetadata> parseAndValidateMetadata(Class<?> var1);

    public static class Default
    extends BaseContract {
        @Override
        protected void processAnnotationOnClass(MethodMetadata data, Class<?> targetType) {
        }

        @Override
        protected void processAnnotationOnMethod(MethodMetadata data, Annotation methodAnnotation, Method method) {
            Class<? extends Annotation> annotationType = methodAnnotation.annotationType();
            if (annotationType == ShackleDomain.class) {
                String shackleDomain = ((ShackleDomain)ShackleDomain.class.cast(methodAnnotation)).value();
                Util.checkState(Util.emptyToNull(shackleDomain) != null, "ShackleDomain annotation was empty on method %s.", method.getName());
                ShackleDomain domain = (ShackleDomain)methodAnnotation;
                Class<? extends WdServiceCallback<?>> callback = domain.domain();
                String wdServiceTemplateBeanName = domain.wdServiceTemplateBeanName();
                String domainName = domain.domainName();
                DomainTemplate domainTemplate = new DomainTemplate(callback, domain.withTrans(), wdServiceTemplateBeanName, domainName);
                data.template(domainTemplate);
                data.argTypes(method.getParameterTypes());
            }
        }
    }

    public static abstract class BaseContract
    implements Contract {
        @Override
        public List<MethodMetadata> parseAndValidateMetadata(Class<?> targetType) {
            Util.checkState(targetType.getTypeParameters().length == 0, "Parameterized types unsupported: %s", targetType.getSimpleName());
            Util.checkState(targetType.getInterfaces().length <= 1, "Only single inheritance supported: %s", targetType.getSimpleName());
            if (targetType.getInterfaces().length == 1) {
                Util.checkState(targetType.getInterfaces()[0].getInterfaces().length == 0, "Only single-level inheritance supported: %s", targetType.getSimpleName());
            }
            LinkedHashMap<String, MethodMetadata> result = new LinkedHashMap<String, MethodMetadata>();
            for (Method method : targetType.getMethods()) {
                if (method.getDeclaringClass() == Object.class || (method.getModifiers() & 8) != 0 || Util.isDefault(method)) continue;
                MethodMetadata metadata = this.parseAndValidateMetadata(targetType, method);
                Util.checkState(!result.containsKey(metadata.configKey()), "Overrides unsupported: %s", metadata.configKey());
                result.put(metadata.configKey(), metadata);
            }
            return new ArrayList<MethodMetadata>(result.values());
        }

        protected MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
            MethodMetadata data = new MethodMetadata();
            data.returnType(Types.resolve(targetType, targetType, method.getGenericReturnType()));
            data.configKey(Shackle.configKey(targetType, method));
            if (targetType.getInterfaces().length == 1) {
                this.processAnnotationOnClass(data, targetType.getInterfaces()[0]);
            }
            this.processAnnotationOnClass(data, targetType);
            for (Annotation methodAnnotation : method.getAnnotations()) {
                this.processAnnotationOnMethod(data, methodAnnotation, method);
            }
            return data;
        }

        protected abstract void processAnnotationOnClass(MethodMetadata var1, Class<?> var2);

        protected abstract void processAnnotationOnMethod(MethodMetadata var1, Annotation var2, Method var3);
    }
}

