/*
 * Decompiled with CFR 0.152.
 */
package com.github.biticcf.mountain.shackle;

import com.github.biticcf.mountain.core.common.lang.Logable;
import com.github.biticcf.mountain.core.common.result.CallResult;
import com.github.biticcf.mountain.core.common.result.WdCallbackResult;
import com.github.biticcf.mountain.core.common.service.ReferContext;
import com.github.biticcf.mountain.core.common.service.WdServiceCallback;
import com.github.biticcf.mountain.core.common.service.WdServiceTemplate;
import com.github.biticcf.mountain.shackle.Domain;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public interface DomainExecutor {
    public CallResult<?> execute(Domain var1, Object[] var2, Class<?>[] var3) throws Exception;

    default public <T> CallResult<T> makeResult(WdCallbackResult<T> result) {
        return CallResult.makeCallResult((boolean)result.isSuccess(), (int)result.getResultCode(), (String)result.getResultMessage(), (Object)result.getBusinessObject(), (Throwable)result.getThrowable());
    }

    public static class Default
    implements DomainExecutor,
    Logable {
        private static Logger logger = LoggerFactory.getLogger(Default.class);
        private final WdServiceTemplate wdServiceTemplate;
        private final ReferContext referContext;
        private final ApplicationContext applicationContext;

        public Default(WdServiceTemplate wdServiceTemplate, ReferContext referContext, ApplicationContext applicationContext) {
            this.wdServiceTemplate = wdServiceTemplate;
            this.referContext = referContext;
            this.applicationContext = applicationContext;
        }

        @Override
        public CallResult<?> execute(Domain domain, Object[] args, Class<?>[] argTypes) throws Exception {
            WdServiceCallback<?> callback;
            boolean withTrans = domain.withTrans();
            Class<WdServiceCallback<?>> callbackClz = domain.callback();
            String wdServiceTemplateBeanName = domain.wdServiceTemplateBeanName();
            WdServiceTemplate wdServiceTemplateMethod = this.getByNameOptional(wdServiceTemplateBeanName, WdServiceTemplate.class);
            WdServiceTemplate wdServiceTemplateUsed = this.wdServiceTemplate;
            if (wdServiceTemplateMethod != null) {
                this.writeInfoLog(logger, "Defined WdServiceTemplate On Method Instead Of In Configuration.");
                wdServiceTemplateUsed = wdServiceTemplateMethod;
            }
            if (wdServiceTemplateUsed == null) {
                throw new NoSuchBeanDefinitionException("WdServiceTemplate");
            }
            int argv = 0;
            if (args != null && args.length > 0) {
                argv = args.length;
            }
            Object[] argsNew = new Object[argv + 1];
            Class[] parameterTypes = new Class[argv + 1];
            argsNew[0] = this.referContext;
            parameterTypes[0] = this.referContext.getClass();
            for (int i = 1; i < argsNew.length; ++i) {
                argsNew[i] = args[i - 1];
                parameterTypes[i] = argTypes[i - 1];
            }
            String domainName = domain.domainName();
            if (domainName == null || domainName.trim().equals("")) {
                String simpleName = callbackClz.getSimpleName();
                domainName = Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
            }
            if ((callback = (WdServiceCallback<?>)this.getByNameAndArgs(domainName, argsNew)) == null) {
                this.writeWarnLog(logger, "Domain bean[" + callbackClz + "] Not found, Create a new Instance.");
                Constructor<WdServiceCallback<?>> ct = null;
                try {
                    ct = callbackClz.getConstructor(parameterTypes);
                }
                catch (Exception e) {
                    ct = null;
                }
                if (ct == null) {
                    this.writeErrorLog(logger, "Domain bean[" + callbackClz + "] Not found, Create new Instance Fail, Exit!");
                    throw new NoSuchMethodException("No Suitable Public Constructor!");
                }
                callback = ct.newInstance(argsNew);
            }
            if (callback == null) {
                throw new NoSuchBeanDefinitionException("WdServiceCallback", "With Args[" + argsNew + "].");
            }
            WdCallbackResult result = null;
            result = !withTrans ? wdServiceTemplateUsed.executeWithoutTransaction((WdServiceCallback)callback, null) : wdServiceTemplateUsed.execute((WdServiceCallback)callback, null);
            return this.makeResult(result);
        }

        private <T> T getByNameOptional(String beanName, Class<T> tClass) {
            if (beanName == null || beanName.trim().equals("")) {
                return null;
            }
            beanName = beanName.trim();
            Object beanObj = null;
            try {
                beanObj = this.applicationContext.getBean(beanName);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
            if (beanObj == null) {
                return null;
            }
            if (!tClass.isAssignableFrom(beanObj.getClass())) {
                throw new NoSuchBeanDefinitionException(beanName);
            }
            return (T)beanObj;
        }

        private <T> T getByNameAndArgs(String beanName, Object ... args) {
            return (T)this.applicationContext.getBean(beanName, args);
        }
    }
}

