/*
 * Decompiled with CFR 0.152.
 */
package com.github.biticcf.mountain.shackle;

import com.github.biticcf.mountain.shackle.Contract;
import com.github.biticcf.mountain.shackle.DefaultMethodHandler;
import com.github.biticcf.mountain.shackle.DomainTemplate;
import com.github.biticcf.mountain.shackle.InvocationHandlerFactory;
import com.github.biticcf.mountain.shackle.MethodMetadata;
import com.github.biticcf.mountain.shackle.Shackle;
import com.github.biticcf.mountain.shackle.SynchronousMethodHandler;
import com.github.biticcf.mountain.shackle.Target;
import com.github.biticcf.mountain.shackle.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ReflectiveShackle
extends Shackle {
    private final ParseHandlersByName targetToHandlersByName;
    private final InvocationHandlerFactory factory;

    ReflectiveShackle(ParseHandlersByName targetToHandlersByName, InvocationHandlerFactory factory) {
        this.targetToHandlersByName = targetToHandlersByName;
        this.factory = factory;
    }

    @Override
    public <T> T newInstance(Target<T> target) {
        Map<String, InvocationHandlerFactory.MethodHandler> nameToHandler = this.targetToHandlersByName.apply(target);
        LinkedHashMap<Method, InvocationHandlerFactory.MethodHandler> methodToHandler = new LinkedHashMap<Method, InvocationHandlerFactory.MethodHandler>();
        LinkedList<DefaultMethodHandler> defaultMethodHandlers = new LinkedList<DefaultMethodHandler>();
        for (Method method : target.type().getMethods()) {
            if (method.getDeclaringClass() == Object.class) continue;
            if (Util.isDefault(method)) {
                DefaultMethodHandler handler = new DefaultMethodHandler(method);
                defaultMethodHandlers.add(handler);
                methodToHandler.put(method, handler);
                continue;
            }
            methodToHandler.put(method, nameToHandler.get(Shackle.configKey(target.type(), method)));
        }
        InvocationHandler handler = this.factory.create(target, methodToHandler);
        Object proxy = Proxy.newProxyInstance(target.type().getClassLoader(), new Class[]{target.type()}, handler);
        for (DefaultMethodHandler defaultMethodHandler : defaultMethodHandlers) {
            defaultMethodHandler.bindTo(proxy);
        }
        return (T)proxy;
    }

    private static class BuildTemplateByResolvingArgs
    implements DomainTemplate.Factory {
        protected final MethodMetadata metadata;

        private BuildTemplateByResolvingArgs(MethodMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public DomainTemplate create(Object[] argv) {
            return new DomainTemplate(this.metadata.template());
        }
    }

    static final class ParseHandlersByName {
        private final Contract contract;
        private final SynchronousMethodHandler.Factory factory;

        ParseHandlersByName(Contract contract, SynchronousMethodHandler.Factory factory) {
            this.contract = contract;
            this.factory = factory;
        }

        public Map<String, InvocationHandlerFactory.MethodHandler> apply(Target<?> key) {
            List<MethodMetadata> metadata = this.contract.parseAndValidateMetadata(key.type());
            LinkedHashMap<String, InvocationHandlerFactory.MethodHandler> result = new LinkedHashMap<String, InvocationHandlerFactory.MethodHandler>();
            for (MethodMetadata md : metadata) {
                BuildTemplateByResolvingArgs buildTemplate = new BuildTemplateByResolvingArgs(md);
                result.put(md.configKey(), this.factory.create(key, md, buildTemplate));
            }
            return result;
        }
    }

    static class ShackleInvocationHandler
    implements InvocationHandler {
        private final Target<?> target;
        private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;

        ShackleInvocationHandler(Target<?> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
            this.target = Util.checkNotNull(target, "target", new Object[0]);
            this.dispatch = Util.checkNotNull(dispatch, "dispatch for %s", target);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("equals".equals(method.getName())) {
                try {
                    InvocationHandler otherHandler = args.length > 0 && args[0] != null ? Proxy.getInvocationHandler(args[0]) : null;
                    return this.equals(otherHandler);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            if ("hashCode".equals(method.getName())) {
                return this.hashCode();
            }
            if ("toString".equals(method.getName())) {
                return this.toString();
            }
            return this.dispatch.get(method).invoke(args);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ShackleInvocationHandler) {
                ShackleInvocationHandler other = (ShackleInvocationHandler)obj;
                return this.target.equals(other.target);
            }
            return false;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public String toString() {
            return this.target.toString();
        }
    }
}

