/*
 * Decompiled with CFR 0.152.
 */
package com.github.biticcf.mountain.shackle;

import com.github.biticcf.mountain.shackle.Contract;
import com.github.biticcf.mountain.shackle.DomainExecutor;
import com.github.biticcf.mountain.shackle.InvocationHandlerFactory;
import com.github.biticcf.mountain.shackle.ReflectiveShackle;
import com.github.biticcf.mountain.shackle.SynchronousMethodHandler;
import com.github.biticcf.mountain.shackle.Target;
import com.github.biticcf.mountain.shackle.Types;
import com.github.biticcf.mountain.shackle.Util;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public abstract class Shackle {
    public static Builder builder() {
        return new Builder();
    }

    public static String configKey(Class<?> targetType, Method method) {
        StringBuilder builder = new StringBuilder();
        builder.append(targetType.getSimpleName());
        builder.append('#').append(method.getName()).append('(');
        for (Type param : method.getGenericParameterTypes()) {
            param = Types.resolve(targetType, targetType, param);
            builder.append(Types.getRawType(param).getSimpleName()).append(',');
        }
        if (method.getParameterTypes().length > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.append(')').toString();
    }

    public abstract <T> T newInstance(Target<T> var1);

    public static class Builder {
        private Contract contract;
        private DomainExecutor domainExecutor;
        private InvocationHandlerFactory invocationHandlerFactory = new InvocationHandlerFactory.Default();

        public Builder contract(Contract contract) {
            this.contract = contract;
            return this;
        }

        public Builder domainExecutor(DomainExecutor domainExecutor) {
            this.domainExecutor = domainExecutor;
            return this;
        }

        public Builder invocationHandlerFactory(InvocationHandlerFactory invocationHandlerFactory) {
            this.invocationHandlerFactory = invocationHandlerFactory;
            return this;
        }

        public <T> T target(Class<T> apiType, String name) {
            return this.target(new Target.HardCodedTarget<T>(apiType, name));
        }

        public <T> T target(Target<T> target) {
            return this.build().newInstance(target);
        }

        public Shackle build() {
            Util.checkNotNull(this.contract, "Contract Can not Null!", new Object[0]);
            SynchronousMethodHandler.Factory synchronousMethodHandlerFactory = new SynchronousMethodHandler.Factory(this.domainExecutor);
            ReflectiveShackle.ParseHandlersByName handlersByName = new ReflectiveShackle.ParseHandlersByName(this.contract, synchronousMethodHandlerFactory);
            return new ReflectiveShackle(handlersByName, this.invocationHandlerFactory);
        }
    }
}

