/*
 * Decompiled with CFR 0.152.
 */
package com.github.biticcf.mountain.shackle;

import com.github.biticcf.mountain.core.common.lang.Logable;
import com.github.biticcf.mountain.core.common.service.ReferContext;
import com.github.biticcf.mountain.core.common.service.WdServiceTemplate;
import com.github.biticcf.mountain.shackle.Contract;
import com.github.biticcf.mountain.shackle.DomainExecutor;
import com.github.biticcf.mountain.shackle.Shackle;
import com.github.biticcf.mountain.shackle.ShackleContext;
import com.github.biticcf.mountain.shackle.ShackleTemplateProperties;
import com.github.biticcf.mountain.shackle.Target;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

class ShackleTemplateFactoryBean
implements FactoryBean<Object>,
InitializingBean,
ApplicationContextAware,
Logable {
    private static Logger logger = LoggerFactory.getLogger(ShackleTemplateFactoryBean.class);
    private Class<?> type;
    private String name;
    private ApplicationContext applicationContext;
    private String wdServiceTemplateBeanName;
    private String defaultServiceTemplateBeanName;

    ShackleTemplateFactoryBean() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.name, (String)"Name must be set");
    }

    public Object getObject() throws Exception {
        return this.getTarget();
    }

    <T> T getTarget() {
        ShackleContext context = (ShackleContext)((Object)this.applicationContext.getBean(ShackleContext.class));
        Shackle.Builder builder = this.shackle(context);
        return (T)builder.target(new Target.HardCodedTarget(this.type, this.name));
    }

    protected <T> T getOptional(ShackleContext context, Class<T> type) {
        return (T)context.getInstance(this.name, type);
    }

    protected Shackle.Builder shackle(ShackleContext context) {
        DomainExecutor domainExecutor = this.getOptional(context, DomainExecutor.class);
        if (domainExecutor == null) {
            this.writeInfoLog(logger, "Configuration domainExecutor is null, Begin define domainExecutor ...");
            if (this.defaultServiceTemplateBeanName == null || this.defaultServiceTemplateBeanName.trim().equals("")) {
                this.defaultServiceTemplateBeanName = "wdServiceTemplate";
            }
            WdServiceTemplate wdServiceTemplate = this.getByTypeOrName(WdServiceTemplate.class, this.defaultServiceTemplateBeanName);
            WdServiceTemplate wdServiceTemplateClass = this.getByNameOptional(this.wdServiceTemplateBeanName, WdServiceTemplate.class);
            WdServiceTemplate wdServiceTemplateUsed = wdServiceTemplate;
            if (wdServiceTemplateClass != null) {
                this.writeInfoLog(logger, "Defined WdServiceTemplate On Service Class Instead Of In Configuration.");
                wdServiceTemplateUsed = wdServiceTemplateClass;
            }
            ReferContext referContext = this.get(context, ReferContext.class, new Object[0]);
            domainExecutor = new DomainExecutor.Default(wdServiceTemplateUsed, referContext, this.applicationContext);
        }
        Contract.Default contract = (Contract.Default)this.get(context, Contract.class, new Object[0]);
        Shackle.Builder builder = this.get(context, Shackle.Builder.class, new Object[0]).contract(contract).domainExecutor(domainExecutor);
        this.configureShackle(context, builder);
        return builder;
    }

    protected void configureShackle(ShackleContext context, Shackle.Builder builder) {
        ShackleTemplateProperties properties = (ShackleTemplateProperties)this.applicationContext.getBean(ShackleTemplateProperties.class);
        if (properties != null) {
            if (properties.isDefaultToProperties()) {
                this.configureUsingConfiguration(context, builder);
                this.configureUsingProperties(properties.getConfig().get(properties.getDefaultConfig()), builder);
                this.configureUsingProperties(properties.getConfig().get(this.name), builder);
            } else {
                this.configureUsingProperties(properties.getConfig().get(properties.getDefaultConfig()), builder);
                this.configureUsingProperties(properties.getConfig().get(this.name), builder);
                this.configureUsingConfiguration(context, builder);
            }
        } else {
            this.configureUsingConfiguration(context, builder);
        }
    }

    protected void configureUsingConfiguration(ShackleContext context, Shackle.Builder builder) {
    }

    protected void configureUsingProperties(ShackleTemplateProperties.ShackleTemplateConfiguration config, Shackle.Builder builder) {
        if (config == null) {
            return;
        }
        if (Objects.nonNull(config.getContract())) {
            builder.contract(this.getOrInstantiate(config.getContract()));
        }
    }

    private <T> T getByTypeOrName(Class<T> tClass, String beanName) {
        try {
            return (T)this.applicationContext.getBean(tClass);
        }
        catch (Exception e) {
            try {
                return (T)this.applicationContext.getBean(beanName, tClass);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private <T> T getOrInstantiate(Class<T> tClass) {
        try {
            return (T)this.applicationContext.getBean(tClass);
        }
        catch (NoSuchBeanDefinitionException e) {
            return (T)BeanUtils.instantiateClass(tClass);
        }
    }

    private <T> T getByNameOptional(String beanName, Class<T> tClass) {
        if (beanName == null || beanName.trim().equals("")) {
            return null;
        }
        beanName = beanName.trim();
        Object beanObj = null;
        try {
            beanObj = this.applicationContext.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (beanObj == null) {
            return null;
        }
        if (!tClass.isAssignableFrom(beanObj.getClass())) {
            throw new NoSuchBeanDefinitionException(beanName);
        }
        return (T)beanObj;
    }

    protected <T> T get(ShackleContext context, Class<T> type, Object ... args) {
        T instance = context.getInstance(this.name, type, args);
        if (instance == null) {
            throw new IllegalStateException("No bean found of type " + type + " for " + this.name);
        }
        return instance;
    }

    protected <T> T get(ShackleContext context, String beanName, Class<T> type) {
        Object instance = context.getInstanceByName(this.name, beanName, new Object[0]);
        if (instance == null) {
            throw new IllegalStateException("No bean found of name " + beanName + " for " + this.name);
        }
        if (!instance.getClass().isAssignableFrom(type)) {
            throw new IllegalStateException("The name " + beanName + " not found for " + this.name);
        }
        return (T)instance;
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public String getWdServiceTemplateBeanName() {
        return this.wdServiceTemplateBeanName;
    }

    public void setWdServiceTemplateBeanName(String wdServiceTemplateBeanName) {
        this.wdServiceTemplateBeanName = wdServiceTemplateBeanName;
    }

    public String getDefaultServiceTemplateBeanName() {
        return this.defaultServiceTemplateBeanName;
    }

    public void setDefaultServiceTemplateBeanName(String defaultServiceTemplateBeanName) {
        this.defaultServiceTemplateBeanName = defaultServiceTemplateBeanName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShackleTemplateFactoryBean that = (ShackleTemplateFactoryBean)o;
        return Objects.equals(this.applicationContext, that.applicationContext) && Objects.equals(this.name, that.name) && Objects.equals(this.wdServiceTemplateBeanName, that.wdServiceTemplateBeanName) && Objects.equals(this.type, that.type) && Objects.equals(this.defaultServiceTemplateBeanName, that.defaultServiceTemplateBeanName);
    }

    public int hashCode() {
        return Objects.hash(this.applicationContext, this.name, this.wdServiceTemplateBeanName, this.type, this.defaultServiceTemplateBeanName);
    }

    public String toString() {
        return "ShackleTemplateFactoryBean{" + "type=" + this.type + ", " + "name='" + this.name + "', " + "wdServiceTemplateBeanName='" + this.wdServiceTemplateBeanName + "', " + "defaultServiceTemplateBeanName='" + this.defaultServiceTemplateBeanName + "', " + "applicationContext=" + this.applicationContext + "}";
    }
}

