/*
 * Decompiled with CFR 0.152.
 */
package com.github.biticcf.mountain.shackle;

import com.github.biticcf.mountain.shackle.EnableShackleTemplates;
import com.github.biticcf.mountain.shackle.ShackleTemplate;
import com.github.biticcf.mountain.shackle.ShackleTemplateFactoryBean;
import com.github.biticcf.mountain.shackle.ShackleTemplateSpecification;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AbstractClassTestingTypeFilter;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ShackleTemplatesRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        this.registerDefaultConfiguration(metadata, registry);
        this.registerShackleTemplates(metadata, registry);
    }

    private void registerDefaultConfiguration(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Map defaultAttrs = metadata.getAnnotationAttributes(EnableShackleTemplates.class.getName(), true);
        if (defaultAttrs != null && defaultAttrs.containsKey("defaultConfiguration")) {
            String name = metadata.hasEnclosingClass() ? "default." + metadata.getEnclosingClassName() : "default." + metadata.getClassName();
            this.registerTemplateConfiguration(registry, name, defaultAttrs.get("defaultConfiguration"));
        }
    }

    public void registerShackleTemplates(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Set<String> basePackages;
        Class[] templates;
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        Map attrs = metadata.getAnnotationAttributes(EnableShackleTemplates.class.getName());
        String defaultServiceTemplateBeanName = (String)attrs.get("defaultServiceTemplateBeanName");
        AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter(ShackleTemplate.class);
        Class[] classArray = templates = attrs == null ? null : (Class[])attrs.get("templates");
        if (templates == null || templates.length == 0) {
            scanner.addIncludeFilter((TypeFilter)annotationTypeFilter);
            basePackages = this.getBasePackages(metadata);
        } else {
            final HashSet<String> templateClasses = new HashSet<String>();
            basePackages = new HashSet<String>();
            for (Class clazz : templates) {
                basePackages.add(ClassUtils.getPackageName((Class)clazz));
                templateClasses.add(clazz.getCanonicalName());
            }
            AbstractClassTestingTypeFilter filter = new AbstractClassTestingTypeFilter(){

                protected boolean match(ClassMetadata metadata) {
                    String cleaned = metadata.getClassName().replaceAll("\\$", ".");
                    return templateClasses.contains(cleaned);
                }
            };
            scanner.addIncludeFilter((TypeFilter)new AllTypeFilter(Arrays.asList(filter, annotationTypeFilter)));
        }
        for (String basePackage : basePackages) {
            Set candidateComponents = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition candidateComponent : candidateComponents) {
                if (!(candidateComponent instanceof AnnotatedBeanDefinition)) continue;
                AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
                AnnotationMetadata annotationMetadata = beanDefinition.getMetadata();
                Assert.isTrue((boolean)annotationMetadata.isInterface(), (String)"@ShackleTemplate can only be specified on an interface");
                Map attributes = annotationMetadata.getAnnotationAttributes(ShackleTemplate.class.getCanonicalName());
                String name = this.getTemplateName(attributes);
                this.registerTemplateConfiguration(registry, name, attributes.get("configuration"));
                this.registerShackleTemplate(registry, annotationMetadata, attributes, defaultServiceTemplateBeanName);
            }
        }
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableShackleTemplates.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : (String[])attributes.get("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : (String[])attributes.get("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : (Class[])attributes.get("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
    }

    private String getTemplateName(Map<String, Object> template) {
        if (template == null) {
            return null;
        }
        String value = (String)template.get("value");
        if (!StringUtils.hasText((String)value)) {
            value = (String)template.get("name");
        }
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        throw new IllegalStateException("Either 'name' or 'value' must be provided in @" + ShackleTemplate.class.getSimpleName());
    }

    private void registerTemplateConfiguration(BeanDefinitionRegistry registry, Object name, Object configuration) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ShackleTemplateSpecification.class);
        builder.addConstructorArgValue(name);
        builder.addConstructorArgValue(configuration);
        registry.registerBeanDefinition(name + "." + ShackleTemplateSpecification.class.getSimpleName(), (BeanDefinition)builder.getBeanDefinition());
    }

    private void registerShackleTemplate(BeanDefinitionRegistry registry, AnnotationMetadata annotationMetadata, Map<String, Object> attributes, String defaultServiceTemplateBeanName) {
        String className = annotationMetadata.getClassName();
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(ShackleTemplateFactoryBean.class);
        String name = this.getName(attributes);
        definition.addPropertyValue("name", (Object)name);
        definition.addPropertyValue("type", (Object)className);
        definition.setAutowireMode(2);
        String alias = name + "ShackleTemplate";
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        boolean primary = (Boolean)attributes.get("primary");
        beanDefinition.setPrimary(primary);
        String wdServiceTemplateBeanName = (String)attributes.get("wdServiceTemplateBeanName");
        definition.addPropertyValue("wdServiceTemplateBeanName", (Object)wdServiceTemplateBeanName);
        definition.addPropertyValue("defaultServiceTemplateBeanName", (Object)defaultServiceTemplateBeanName);
        String qualifier = this.getQualifier(attributes);
        if (StringUtils.hasText((String)qualifier)) {
            alias = qualifier;
        }
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, className, new String[]{alias});
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
    }

    String getName(Map<String, Object> attributes) {
        String name = (String)attributes.get("name");
        if (!StringUtils.hasText((String)name)) {
            name = (String)attributes.get("value");
        }
        name = this.resolve(name);
        return ShackleTemplatesRegistrar.getName(name);
    }

    static String getName(String name) {
        return name;
    }

    private String resolve(String value) {
        if (StringUtils.hasText((String)value)) {
            return this.environment.resolvePlaceholders(value);
        }
        return value;
    }

    private String getQualifier(Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        String qualifier = (String)client.get("qualifier");
        if (StringUtils.hasText((String)qualifier)) {
            return qualifier;
        }
        return null;
    }

    private static class AllTypeFilter
    implements TypeFilter {
        private final List<TypeFilter> delegates;

        public AllTypeFilter(List<TypeFilter> delegates) {
            Assert.notNull(delegates, (String)"This argument is required, it must not be null");
            this.delegates = delegates;
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            for (TypeFilter filter : this.delegates) {
                if (filter.match(metadataReader, metadataReaderFactory)) continue;
                return false;
            }
            return true;
        }
    }
}

