/*
 * Decompiled with CFR 0.152.
 */
package com.github.biticcf.mountain.shackle;

import com.github.biticcf.mountain.shackle.Domain;
import com.github.biticcf.mountain.shackle.DomainExecutor;
import com.github.biticcf.mountain.shackle.DomainTemplate;
import com.github.biticcf.mountain.shackle.InvocationHandlerFactory;
import com.github.biticcf.mountain.shackle.MethodMetadata;
import com.github.biticcf.mountain.shackle.Target;
import com.github.biticcf.mountain.shackle.Util;

final class SynchronousMethodHandler
implements InvocationHandlerFactory.MethodHandler {
    private final MethodMetadata metadata;
    private final Target<?> target;
    private final DomainExecutor domainExecutor;
    private final DomainTemplate.Factory buildTemplateFromArgs;

    private SynchronousMethodHandler(Target<?> target, DomainExecutor domainExecutor, MethodMetadata metadata, DomainTemplate.Factory buildTemplateFromArgs) {
        this.target = Util.checkNotNull(target, "target", new Object[0]);
        this.domainExecutor = Util.checkNotNull(domainExecutor, "domainExecutor for %s", target);
        this.metadata = Util.checkNotNull(metadata, "metadata for %s", target);
        this.buildTemplateFromArgs = Util.checkNotNull(buildTemplateFromArgs, "metadata for %s", target);
    }

    @Override
    public Object invoke(Object[] argv) throws Throwable {
        DomainTemplate template = this.buildTemplateFromArgs.create(argv);
        return this.execute(template, argv);
    }

    Object execute(DomainTemplate template, Object[] args) throws Throwable {
        Domain domain = this.targetDomain(template);
        return this.domainExecutor.execute(domain, args, this.metadata.argTypes());
    }

    Domain targetDomain(DomainTemplate template) {
        return this.target.apply(new DomainTemplate(template));
    }

    static class Factory {
        private final DomainExecutor domainExecutor;

        Factory(DomainExecutor domainExecutor) {
            this.domainExecutor = Util.checkNotNull(domainExecutor, "domainExecutor", new Object[0]);
        }

        public InvocationHandlerFactory.MethodHandler create(Target<?> target, MethodMetadata md, DomainTemplate.Factory buildTemplateFromArgs) {
            return new SynchronousMethodHandler(target, this.domainExecutor, md, buildTemplateFromArgs);
        }
    }
}

