/*
 * Decompiled with CFR 0.152.
 */
package com.github.biticcf.mountain.shackle;

import com.github.biticcf.mountain.shackle.Domain;
import com.github.biticcf.mountain.shackle.DomainTemplate;

public interface Target<T> {
    public Class<T> type();

    public String name();

    public Domain apply(DomainTemplate var1);

    public static class HardCodedTarget<T>
    implements Target<T> {
        private final Class<T> type;
        private final String name;

        public HardCodedTarget(Class<T> type, String name) {
            this.type = type;
            this.name = name;
        }

        @Override
        public Class<T> type() {
            return this.type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Domain apply(DomainTemplate input) {
            return input.domain();
        }

        public boolean equals(Object obj) {
            if (obj instanceof HardCodedTarget) {
                HardCodedTarget other = (HardCodedTarget)obj;
                return this.type.equals(other.type) && this.name.equals(other.name);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public String toString() {
            return "HardCodedTarget(type=" + this.type.getSimpleName() + ", name=" + this.name + ")";
        }
    }
}

