/*
 * Decompiled with CFR 0.152.
 */
package net.bjoernpetersen.m3u;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import net.bjoernpetersen.m3u.M3uParser;
import net.bjoernpetersen.m3u.model.M3uEntry;
import net.bjoernpetersen.m3u.model.M3uMetadata;
import net.bjoernpetersen.m3u.model.MediaLocation;
import net.bjoernpetersen.m3u.model.MediaPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001a\u001a\u00020\u00062\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J$\u0010\u001d\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0006H\u0002J\u001c\u0010$\u001a\u0004\u0018\u00010\u00122\u0006\u0010 \u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J&\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120)H\u0002J&\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J4\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120)H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lnet/bjoernpetersen/m3u/M3uParser;", "", "()V", "COMMENT_START", "", "EXTENDED_HEADER", "", "EXTENDED_INFO", "KEY_VALUE_PAIRS", "", "SECONDS", "TITLE", "infoRegex", "Lkotlin/text/Regex;", "logger", "Lmu/KLogger;", "parse", "", "Lnet/bjoernpetersen/m3u/model/M3uEntry;", "m3uContentReader", "Ljava/io/InputStreamReader;", "baseDir", "Ljava/nio/file/Path;", "m3uFile", "charset", "Ljava/nio/charset/Charset;", "m3uContent", "lines", "Lkotlin/sequences/Sequence;", "parseExtended", "infoMatch", "Lkotlin/text/MatchResult;", "location", "parseMetadata", "Lnet/bjoernpetersen/m3u/model/M3uMetadata;", "keyValues", "parseSimple", "resolveNestedPlaylist", "", "path", "result", "", "resolveNestedPlaylists", "entries", "resolveRecursively", "source", "m3u-parser"})
public final class M3uParser {
    @NotNull
    public static final M3uParser INSTANCE = new M3uParser();
    private static final char COMMENT_START = '#';
    @NotNull
    private static final String EXTENDED_HEADER = "#EXTM3U";
    private static final int SECONDS = 1;
    private static final int KEY_VALUE_PAIRS = 2;
    private static final int TITLE = 3;
    @NotNull
    private static final String EXTENDED_INFO = "#EXTINF:([-]?\\d+)(.*),(.+)";
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private static final Regex infoRegex = new Regex("#EXTINF:([-]?\\d+)(.*),(.+)");

    private M3uParser() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<M3uEntry> parse(@NotNull Path m3uFile, @NotNull Charset charset) throws IOException {
        Intrinsics.checkNotNullParameter((Object)m3uFile, (String)"m3uFile");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        boolean bl = Files.isRegularFile(m3uFile, new LinkOption[0]);
        if (!bl) {
            boolean bl2 = false;
            String string = m3uFile + " is not a file";
            throw new IllegalArgumentException(string.toString());
        }
        Stream<String> stream = Files.lines(m3uFile, charset);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"lines(m3uFile, charset)");
        return INSTANCE.parse((Sequence<String>)StreamsKt.asSequence(stream), m3uFile.getParent());
    }

    public static /* synthetic */ List parse$default(Path path, Charset charset, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return M3uParser.parse(path, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<M3uEntry> parse(@NotNull InputStreamReader m3uContentReader, @Nullable Path baseDir) {
        List<M3uEntry> list;
        Intrinsics.checkNotNullParameter((Object)m3uContentReader, (String)"m3uContentReader");
        Reader reader = m3uContentReader;
        int n = 8192;
        Reader $this$useLines$iv = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        int n2 = 8192;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            list = INSTANCE.parse((Sequence<String>)it, baseDir);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    public static /* synthetic */ List parse$default(InputStreamReader inputStreamReader, Path path, int n, Object object) {
        if ((n & 2) != 0) {
            path = null;
        }
        return M3uParser.parse(inputStreamReader, path);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<M3uEntry> parse(@NotNull String m3uContent, @Nullable Path baseDir) {
        Intrinsics.checkNotNullParameter((Object)m3uContent, (String)"m3uContent");
        return INSTANCE.parse((Sequence<String>)StringsKt.lineSequence((CharSequence)m3uContent), baseDir);
    }

    public static /* synthetic */ List parse$default(String string, Path path, int n, Object object) {
        if ((n & 2) != 0) {
            path = null;
        }
        return M3uParser.parse(string, path);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<M3uEntry> resolveNestedPlaylists(@NotNull List<M3uEntry> entries, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return M3uParser.resolveRecursively$default(INSTANCE, entries, charset, null, 4, null);
    }

    public static /* synthetic */ List resolveNestedPlaylists$default(List list, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return M3uParser.resolveNestedPlaylists(list, charset);
    }

    private final List<M3uEntry> parse(Sequence<String> lines, Path baseDir) {
        Iterator filtered2 = SequencesKt.dropWhile((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot(lines, (Function1)parse.filtered.1.INSTANCE), (Function1)parse.filtered.2.INSTANCE), (Function1)parse.filtered.3.INSTANCE).iterator();
        if (!filtered2.hasNext()) {
            return CollectionsKt.emptyList();
        }
        LinkedList<M3uEntry> entries = new LinkedList<M3uEntry>();
        Ref.ObjectRef currentLine = new Ref.ObjectRef();
        Ref.ObjectRef match = new Ref.ObjectRef();
        while (filtered2.hasNext()) {
            currentLine.element = filtered2.next();
            while (StringsKt.startsWith$default((CharSequence)((CharSequence)currentLine.element), (char)'#', (boolean)false, (int)2, null)) {
                MatchResult newMatch = infoRegex.matchEntire((CharSequence)currentLine.element);
                if (newMatch != null) {
                    if (match.element != null) {
                        logger.debug((Function0)new Function0<Object>((Ref.ObjectRef<MatchResult>)match){
                            final /* synthetic */ Ref.ObjectRef<MatchResult> $match;
                            {
                                this.$match = $match;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                Object object = this.$match.element;
                                Intrinsics.checkNotNull((Object)object);
                                return Intrinsics.stringPlus((String)"Ignoring info line: ", (Object)((MatchResult)object).getValue());
                            }
                        });
                    }
                    match.element = newMatch;
                } else {
                    logger.debug((Function0)new Function0<Object>((Ref.ObjectRef<String>)currentLine){
                        final /* synthetic */ Ref.ObjectRef<String> $currentLine;
                        {
                            this.$currentLine = $currentLine;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return Intrinsics.stringPlus((String)"Ignoring comment line ", (Object)this.$currentLine.element);
                        }
                    });
                }
                if (filtered2.hasNext()) {
                    currentLine.element = filtered2.next();
                    continue;
                }
                return entries;
            }
            if (StringsKt.startsWith$default((CharSequence)((CharSequence)currentLine.element), (char)'#', (boolean)false, (int)2, null)) continue;
            M3uEntry entry = match.element == null ? this.parseSimple((String)currentLine.element, baseDir) : this.parseExtended((MatchResult)match.element, (String)currentLine.element, baseDir);
            match.element = null;
            if (entry != null) {
                entries.add(entry);
                continue;
            }
            logger.warn(Intrinsics.stringPlus((String)"Ignored line ", (Object)currentLine.element));
        }
        return entries;
    }

    private final M3uEntry parseSimple(String location, Path baseDir) {
        M3uEntry m3uEntry;
        try {
            m3uEntry = new M3uEntry(MediaLocation.Companion.invoke(location, baseDir), null, null, null, 14, null);
        }
        catch (IllegalArgumentException e) {
            logger.warn((Throwable)e, (Function0)new Function0<Object>(location){
                final /* synthetic */ String $location;
                {
                    this.$location = $location;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)"Could not parse as location: ", (Object)this.$location);
                }
            });
            m3uEntry = null;
        }
        return m3uEntry;
    }

    private final M3uEntry parseExtended(MatchResult infoMatch, String location, Path baseDir) {
        Long l;
        String string;
        Duration duration;
        MediaLocation mediaLocation2;
        try {
            mediaLocation2 = MediaLocation.Companion.invoke(location, baseDir);
        }
        catch (IllegalArgumentException e) {
            logger.warn((Throwable)e, (Function0)new Function0<Object>(location){
                final /* synthetic */ String $location;
                {
                    this.$location = $location;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)"Could not parse as location: ", (Object)this.$location);
                }
            });
            return null;
        }
        MediaLocation mediaLocation3 = mediaLocation2;
        MatchGroup e = infoMatch.getGroups().get(1);
        if (e == null) {
            duration = null;
        } else {
            string = e.getValue();
            if (string == null) {
                duration = null;
            } else {
                Object object = string;
                l = Long.parseLong((String)object);
                Object object2 = l;
                long it = ((Number)object2).longValue();
                boolean bl = false;
                object = it < 0L ? null : Long.valueOf(it);
                if (object == null) {
                    duration = null;
                } else {
                    object2 = object;
                    it = ((Number)object2).longValue();
                    boolean bl2 = false;
                    duration = Duration.ofSeconds(it);
                }
            }
        }
        Duration duration2 = duration;
        string = infoMatch.getGroups().get(2);
        M3uMetadata metadata = this.parseMetadata(string == null ? null : string.getValue());
        l = infoMatch.getGroups().get(3);
        String title = l == null ? null : l.getValue();
        return new M3uEntry(mediaLocation3, duration2, title, metadata);
    }

    private final M3uMetadata parseMetadata(String keyValues) {
        if (keyValues == null) {
            return M3uMetadata.Companion.empty();
        }
        Regex keyValuePattern = new Regex("([\\w-_.]+)=\"(.*?)\"( )?");
        HashMap<String, String> valueByKey = new HashMap<String, String>();
        String string = keyValues;
        for (MatchResult match : Regex.findAll$default((Regex)keyValuePattern, (CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString(), (int)0, (int)2, null)) {
            String value;
            String string2;
            MatchGroup matchGroup = match.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            String key = matchGroup.getValue();
            MatchGroup matchGroup2 = match.getGroups().get(2);
            if (matchGroup2 == null) {
                string2 = null;
            } else {
                String string3 = matchGroup2.getValue();
                if (string3 == null) {
                    string2 = null;
                } else {
                    CharSequence charSequence;
                    CharSequence charSequence2 = string3;
                    if (StringsKt.isBlank((CharSequence)charSequence2)) {
                        boolean bl = false;
                        charSequence = null;
                    } else {
                        charSequence = charSequence2;
                    }
                    string2 = value = (String)charSequence;
                }
            }
            if (value == null) {
                logger.debug((Function0)new Function0<Object>(key){
                    final /* synthetic */ String $key;
                    {
                        this.$key = $key;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return Intrinsics.stringPlus((String)"Ignoring blank value for key ", (Object)this.$key);
                    }
                });
                continue;
            }
            String overwritten = valueByKey.put(key, value);
            if (overwritten == null) continue;
            logger.info((Function0)new Function0<Object>(key, overwritten, value){
                final /* synthetic */ String $key;
                final /* synthetic */ String $overwritten;
                final /* synthetic */ String $value;
                {
                    this.$key = $key;
                    this.$overwritten = $overwritten;
                    this.$value = $value;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Overwrote value for duplicate metadata key " + this.$key + ": '" + this.$overwritten + "' -> '" + this.$value + '\'';
                }
            });
        }
        return new M3uMetadata((Map<String, String>)valueByKey);
    }

    private final List<M3uEntry> resolveRecursively(List<M3uEntry> source, Charset charset, List<M3uEntry> result) {
        for (M3uEntry entry : source) {
            MediaLocation location = entry.getLocation();
            if (location instanceof MediaPath && ((MediaPath)location).isPlaylistPath()) {
                this.resolveNestedPlaylist(((MediaPath)location).getPath(), charset, result);
                continue;
            }
            result.add(entry);
        }
        return result;
    }

    static /* synthetic */ List resolveRecursively$default(M3uParser m3uParser, List list, Charset charset, List list2, int n, Object object) {
        if ((n & 4) != 0) {
            list2 = new LinkedList();
        }
        return m3uParser.resolveRecursively(list, charset, list2);
    }

    private final void resolveNestedPlaylist(Path path, Charset charset, List<M3uEntry> result) {
        List<M3uEntry> list;
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return;
        }
        try {
            list = M3uParser.parse(path, charset);
        }
        catch (IOException e) {
            logger.warn((Throwable)e, (Function0)new Function0<Object>(path){
                final /* synthetic */ Path $path;
                {
                    this.$path = $path;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)"Could not parse nested playlist file: ", (Object)this.$path);
                }
            });
            return;
        }
        List<M3uEntry> parsed2 = list;
        this.resolveRecursively(parsed2, charset, result);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<M3uEntry> parse(@NotNull Path m3uFile) throws IOException {
        Intrinsics.checkNotNullParameter((Object)m3uFile, (String)"m3uFile");
        return M3uParser.parse$default(m3uFile, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<M3uEntry> parse(@NotNull InputStreamReader m3uContentReader) {
        Intrinsics.checkNotNullParameter((Object)m3uContentReader, (String)"m3uContentReader");
        return M3uParser.parse$default(m3uContentReader, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<M3uEntry> parse(@NotNull String m3uContent) {
        Intrinsics.checkNotNullParameter((Object)m3uContent, (String)"m3uContent");
        return M3uParser.parse$default(m3uContent, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<M3uEntry> resolveNestedPlaylists(@NotNull List<M3uEntry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        return M3uParser.resolveNestedPlaylists$default(entries, null, 2, null);
    }
}

