/*
 * Decompiled with CFR 0.152.
 */
package net.bjoernpetersen.m3u.model;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import net.bjoernpetersen.m3u.model.MediaLocation;
import net.bjoernpetersen.m3u.model.MediaPath;
import net.bjoernpetersen.m3u.model.MediaUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lnet/bjoernpetersen/m3u/model/MediaLocation;", "", "()V", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "toString", "", "Companion", "Lnet/bjoernpetersen/m3u/model/MediaPath;", "Lnet/bjoernpetersen/m3u/model/MediaUrl;", "m3u-parser"})
public abstract class MediaLocation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String FILE_PROTOCOL = "file";
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);

    private MediaLocation() {
    }

    @NotNull
    public abstract URL getUrl();

    @NotNull
    public String toString() {
        String string = this.getUrl().toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toExternalForm()");
        return string;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MediaLocation invoke(@NotNull String location, @Nullable Path dir) {
        return Companion.invoke(location, dir);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MediaLocation invoke(@NotNull String location) {
        return Companion.invoke(location);
    }

    public /* synthetic */ MediaLocation(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0087\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u001c\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/bjoernpetersen/m3u/model/MediaLocation$Companion;", "", "()V", "FILE_PROTOCOL", "", "logger", "Lmu/KLogger;", "invoke", "Lnet/bjoernpetersen/m3u/model/MediaLocation;", "location", "dir", "Ljava/nio/file/Path;", "tryParseFileUrl", "tryParsePath", "tryParseUrl", "Ljava/net/URL;", "m3u-parser"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final MediaLocation invoke(@NotNull String location, @Nullable Path dir) {
            Object object;
            Object object2;
            MediaPath mediaPath;
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Object object3 = this.tryParseFileUrl(location);
            if (object3 == null) {
                mediaPath = null;
            } else {
                object2 = object3;
                Path it = object2;
                boolean bl = false;
                mediaPath = new MediaPath(it);
            }
            MediaPath mediaPath2 = mediaPath;
            if (mediaPath2 == null) {
                Object object4;
                MediaUrl mediaUrl;
                object2 = this.tryParseUrl(location);
                if (object2 == null) {
                    mediaUrl = null;
                } else {
                    Object it = object4 = object2;
                    boolean bl = false;
                    mediaUrl = new MediaUrl((URL)it);
                }
                object3 = mediaUrl;
                if (object3 == null) {
                    MediaPath mediaPath3;
                    object4 = this.tryParsePath(location, dir);
                    if (object4 == null) {
                        mediaPath3 = null;
                    } else {
                        Object object5;
                        Object it = object5 = object4;
                        boolean bl = false;
                        mediaPath3 = new MediaPath((Path)it);
                    }
                    object2 = mediaPath3;
                    if (object2 == null) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Could not parse as URL or path: ", (Object)location));
                    }
                    object = object2;
                } else {
                    object = object3;
                }
            } else {
                object = mediaPath2;
            }
            return object;
        }

        public static /* synthetic */ MediaLocation invoke$default(Companion companion, String string, Path path, int n, Object object) {
            if ((n & 2) != 0) {
                path = null;
            }
            return companion.invoke(string, path);
        }

        private final Path tryParsePath(String location, Path dir) {
            Path path;
            try {
                path = dir == null ? Paths.get(location, new String[0]) : dir.resolve(location);
            }
            catch (InvalidPathException e) {
                logger.debug((Throwable)e, (Function0)tryParsePath.1.INSTANCE);
                path = null;
            }
            return path;
        }

        private final Path tryParseFileUrl(String location) {
            Path path;
            try {
                URL uRL = this.tryParseUrl(location);
                if (uRL == null) {
                    return null;
                }
                URL url2 = uRL;
                path = Intrinsics.areEqual((Object)url2.getProtocol(), (Object)MediaLocation.FILE_PROTOCOL) ? Paths.get(url2.toURI()) : null;
            }
            catch (URISyntaxException e) {
                logger.debug((Throwable)e, (Function0)new Function0<Object>(location){
                    final /* synthetic */ String $location;
                    {
                        this.$location = $location;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Could not convert URL for " + this.$location + " to a URI";
                    }
                });
                path = null;
            }
            catch (FileSystemNotFoundException e) {
                logger.debug((Throwable)e, (Function0)new Function0<Object>(location){
                    final /* synthetic */ String $location;
                    {
                        this.$location = $location;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "File system specified by " + this.$location + " couldn't be found";
                    }
                });
                path = null;
            }
            catch (IllegalArgumentException e) {
                logger.debug((Throwable)e, (Function0)new Function0<Object>(location){
                    final /* synthetic */ String $location;
                    {
                        this.$location = $location;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return Intrinsics.stringPlus((String)"Could not get Path for ", (Object)this.$location);
                    }
                });
                path = null;
            }
            return path;
        }

        private final URL tryParseUrl(String location) {
            URL uRL;
            try {
                uRL = new URL(location);
            }
            catch (MalformedURLException e) {
                logger.debug(Intrinsics.stringPlus((String)"Could not parse as URL: ", (Object)location));
                uRL = null;
            }
            return uRL;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final MediaLocation invoke(@NotNull String location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            return net.bjoernpetersen.m3u.model.MediaLocation$Companion.invoke$default(this, location, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

