/*
 * Decompiled with CFR 0.152.
 */
package de.mobilej;

import de.mobilej.ProcessRealAndroidJar;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class UnMockTask
extends DefaultTask {
    private FileCollection allAndroid;
    private File outputDir;
    private File unmockedOutputJar;
    private List<String> keepClasses;
    private List<String> renameClasses;
    private List<String> delegateClasses;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public FileCollection getAllAndroid() {
        return this.allAndroid;
    }

    public void setAllAndroid(FileCollection allAndroid) {
        this.allAndroid = allAndroid;
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @OutputFile
    public File getUnmockedOutputJar() {
        return this.unmockedOutputJar;
    }

    public void setUnmockedOutputJar(File unmockedOutputJar) {
        this.unmockedOutputJar = unmockedOutputJar;
    }

    @Input
    public List<String> getKeepClasses() {
        return this.keepClasses;
    }

    public void setKeepClasses(List<String> keepClasses) {
        this.keepClasses = keepClasses;
    }

    @Input
    public List<String> getRenameClasses() {
        return this.renameClasses;
    }

    public void setRenameClasses(List<String> renameClasses) {
        this.renameClasses = renameClasses;
    }

    @Input
    public List<String> getDelegateClasses() {
        return this.delegateClasses;
    }

    public void setDelegateClasses(List<String> delegateClasses) {
        this.delegateClasses = delegateClasses;
    }

    @TaskAction
    public void unmock() {
        Objects.requireNonNull(this.outputDir, "No output directory provided for UnMockTask");
        Objects.requireNonNull(this.unmockedOutputJar, "No output file name provided for UnMockTask");
        Objects.requireNonNull(this.keepClasses, "UnMock keep class list cannot be null");
        Objects.requireNonNull(this.renameClasses, "UnMock rename class list cannot be null");
        Objects.requireNonNull(this.delegateClasses, "UnMock delegate class list cannot be null");
        File allAndroidFile = this.allAndroid.getSingleFile();
        try {
            ProcessRealAndroidJar.process(allAndroidFile, this.outputDir, this.unmockedOutputJar, this.keepClasses.toArray(new String[0]), this.renameClasses.toArray(new String[0]), this.delegateClasses.toArray(new String[0]), this.getLogger());
        }
        catch (Exception e) {
            throw new GradleException("Exception while unmocking", (Throwable)e);
        }
    }
}

