/*
 * Decompiled with CFR 0.152.
 */
package de.mobilej;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRealAndroidJar {
    private static final Logger log = LoggerFactory.getLogger(ProcessRealAndroidJar.class);

    public static void process(File allAndroidFile, File tmpDir, File unmockedOutputJar, String[] keepClasses, String[] renameClasses, String[] delegateClasses, Logger logger) throws Exception {
        List<ClassMapping> classesToMap = ProcessRealAndroidJar.parseClassesToMap(renameClasses, logger);
        ArrayList<String> keepClassesList = new ArrayList<String>(Arrays.asList(keepClasses));
        for (ClassMapping mapping : classesToMap) {
            keepClassesList.add(mapping.from);
        }
        keepClasses = keepClassesList.toArray(new String[0]);
        ProcessRealAndroidJar.delete(tmpDir);
        tmpDir.mkdirs();
        ArrayList<String> clazzNames = ProcessRealAndroidJar.findAllClazzesIn(allAndroidFile.getAbsolutePath());
        ClassPool pool = new ClassPool(null);
        pool.appendSystemPath();
        pool.insertClassPath(allAndroidFile.getAbsolutePath());
        ProcessRealAndroidJar.createHelperClasses(tmpDir, pool);
        ArrayList<CtClass> clazzes = new ArrayList<CtClass>();
        for (String clazzName : clazzNames) {
            CtClass clazz = pool.get(clazzName);
            boolean keep = false;
            for (String keepClass : keepClasses) {
                if (keepClass.startsWith("-")) {
                    String pureKeepClassName = keepClass.substring(1);
                    if (clazz.getName().equals(pureKeepClassName)) {
                        keep = true;
                        break;
                    }
                    if (!clazz.getName().startsWith(pureKeepClassName + "$")) continue;
                    keep = true;
                    break;
                }
                if (!clazz.getName().startsWith(keepClass)) continue;
                keep = true;
                break;
            }
            boolean delegate = false;
            for (String delegateClazzName : delegateClasses) {
                if (clazz.getName().equals(delegateClazzName)) {
                    delegate = true;
                    break;
                }
                if (!clazz.getName().startsWith(delegateClazzName + "$")) continue;
                delegate = true;
                break;
            }
            if (!keep && !delegate) continue;
            try {
                if (keep) {
                    ProcessRealAndroidJar.process(clazz, classesToMap);
                } else if (delegate) {
                    ProcessRealAndroidJar.processDelegate(clazz, classesToMap);
                }
            }
            catch (Exception e) {
                logger.error("-> unable to process", (Throwable)e);
            }
            clazzes.add(clazz);
        }
        for (CtClass clazz : clazzes) {
            clazz.writeFile(tmpDir.getAbsolutePath());
        }
        ArrayList<String> toCopy = new ArrayList<String>();
        ArrayList<String> nonClasses = ProcessRealAndroidJar.findAllNonClassFilesIn(allAndroidFile.getAbsolutePath());
        for (String keep : keepClasses) {
            if (keep.startsWith("-")) continue;
            for (String file : nonClasses) {
                if (!file.startsWith(keep.replace(".", "/"))) continue;
                toCopy.add(file);
            }
        }
        ProcessRealAndroidJar.copyFromJarToDirectory(allAndroidFile.getAbsolutePath(), toCopy, tmpDir.getAbsoluteFile());
        ProcessRealAndroidJar.createJarArchive(unmockedOutputJar.getAbsolutePath(), tmpDir.getAbsolutePath());
    }

    private static List<ClassMapping> parseClassesToMap(String[] renameClasses, Logger logger) {
        ArrayList<ClassMapping> result = new ArrayList<ClassMapping>();
        if (renameClasses == null) {
            return result;
        }
        for (String classRenaming : renameClasses) {
            int indexOfEquals = classRenaming.indexOf("=");
            if (indexOfEquals > 0 && indexOfEquals < classRenaming.length()) {
                String from = classRenaming.substring(0, indexOfEquals);
                String to = classRenaming.substring(indexOfEquals + 1);
                result.add(new ClassMapping(from, to));
                continue;
            }
            logger.error("Unparseable mapping:" + classRenaming);
        }
        return result;
    }

    public static boolean createJarArchive(String outfile, String srcFolder) throws Exception {
        FileOutputStream dest = new FileOutputStream(new File(outfile));
        JarOutputStream out = new JarOutputStream(new BufferedOutputStream(dest));
        ProcessRealAndroidJar.addToJar(out, new File(srcFolder), new File(srcFolder));
        out.flush();
        out.close();
        return true;
    }

    private static void addToJar(JarOutputStream out, File folder, File root) throws Exception {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                ProcessRealAndroidJar.addToJar(out, f, root);
                continue;
            }
            ProcessRealAndroidJar.addJarEntry(out, f, root);
        }
    }

    private static BufferedInputStream addJarEntry(ZipOutputStream out, File f, File root) throws IOException {
        int count;
        int BUFFER = 2048;
        byte[] data = new byte[BUFFER];
        FileInputStream fi = new FileInputStream(f);
        BufferedInputStream origin = new BufferedInputStream(fi, BUFFER);
        String name = f.getCanonicalPath().substring(root.getCanonicalPath().length() + 1).replace('\\', '/');
        JarEntry entry = new JarEntry(name);
        out.putNextEntry(entry);
        while ((count = origin.read(data, 0, BUFFER)) != -1) {
            out.write(data, 0, count);
            out.flush();
        }
        origin.close();
        return origin;
    }

    private static void createHelperClasses(File out, ClassPool pool) throws CannotCompileException, IOException {
        CtClass bridge = pool.makeClass("de.mobilej.ABridge");
        bridge.addMethod(CtMethod.make((String)"public static Object callObject(String signature, Object thiz, Object[] args){return (Object)null;}", (CtClass)bridge));
        bridge.addMethod(CtMethod.make((String)"public static int callInt(String signature, Object thiz, Object[] args){return 0;}", (CtClass)bridge));
        bridge.addMethod(CtMethod.make((String)"public static long callLong(String signature, Object thiz, Object[] args){return 0L;}", (CtClass)bridge));
        bridge.addMethod(CtMethod.make((String)"public static boolean callBoolean(String signature, Object thiz, Object[] args){return false;}", (CtClass)bridge));
        bridge.addMethod(CtMethod.make((String)"public static byte callByte(String signature, Object thiz, Object[] args){return 0;}", (CtClass)bridge));
        bridge.addMethod(CtMethod.make((String)"public static float callFloat(String signature, Object thiz, Object[] args){return 0f;}", (CtClass)bridge));
        bridge.addMethod(CtMethod.make((String)"public static double callDouble(String signature, Object thiz, Object[] args){return 0d;}", (CtClass)bridge));
        bridge.addMethod(CtMethod.make((String)"public static void callVoid(String signature, Object thiz, Object[] args){return;}", (CtClass)bridge));
        bridge.writeFile(out.getAbsolutePath());
    }

    private static ArrayList<String> findAllClazzesIn(String file) throws IOException {
        ArrayList<String> res = new ArrayList<String>();
        ZipFile f = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = f.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            res.add(entry.getName().replace(".class", "").replace("/", "."));
        }
        return res;
    }

    private static ArrayList<String> findAllNonClassFilesIn(String file) throws IOException {
        ArrayList<String> res = new ArrayList<String>();
        ZipFile f = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = f.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || entry.getName().endsWith(".class")) continue;
            res.add(entry.getName());
        }
        return res;
    }

    private static void copyFromJarToDirectory(String file, List<String> files, File destDir) throws IOException {
        try (FileSystem fileSystem = FileSystems.newFileSystem(Paths.get(file, new String[0]), (ClassLoader)null);){
            for (String toCopy : files) {
                Path source = fileSystem.getPath(toCopy, new String[0]);
                File dst = new File(destDir, toCopy);
                dst.getParentFile().mkdirs();
                Files.copy(source, dst.toPath(), new CopyOption[0]);
            }
        }
    }

    private static void processDelegate(CtClass clazz, List<ClassMapping> classMappings) throws Exception {
        CtMethod[] methods;
        if (clazz.isInterface()) {
            return;
        }
        clazz.defrost();
        clazz.setModifiers(clazz.getModifiers() | 1);
        clazz.setModifiers(clazz.getModifiers() & 0xFFFFFFEF);
        clazz.setModifiers(clazz.getModifiers() & 0xFFFFFFFD);
        clazz.setModifiers(clazz.getModifiers() & 0xFFFFFFFB);
        for (CtMethod m : methods = clazz.getDeclaredMethods()) {
            ProcessRealAndroidJar.delegateMethod(m);
            m.setModifiers(m.getModifiers() | 1);
            m.setModifiers(m.getModifiers() & 0xFFFFFFEF);
            m.setModifiers(m.getModifiers() & 0xFFFFFFFD);
            m.setModifiers(m.getModifiers() & 0xFFFFFFFB);
            m.setModifiers(m.getModifiers() & 0xFFFFFEFF);
        }
        CtConstructor[] ctors = clazz.getDeclaredConstructors();
        for (CtConstructor c : ctors) {
            String signature = c.getLongName();
            String thiz = "$0";
            c.setBody("{ de.mobilej.ABridge.callVoid(\"" + signature + "\", " + thiz + ", $args); } ");
            c.setModifiers(c.getModifiers() | 1);
            c.setModifiers(c.getModifiers() & 0xFFFFFFEF);
            c.setModifiers(c.getModifiers() & 0xFFFFFFFD);
            c.setModifiers(c.getModifiers() & 0xFFFFFFFB);
            c.setModifiers(c.getModifiers() & 0xFFFFFEFF);
        }
        for (ClassMapping mapping : classMappings) {
            clazz.replaceClassName(mapping.from, mapping.to);
        }
    }

    private static void delegateMethod(CtMethod m) throws NotFoundException, CannotCompileException {
        String retType;
        String signature = m.getLongName();
        String thiz = "$0";
        if ((m.getModifiers() & 8) == 8) {
            thiz = "null";
        }
        switch (retType = m.getReturnType().getName()) {
            case "void": {
                m.setBody("{ de.mobilej.ABridge.callVoid(\"" + signature + "\", " + thiz + ", $args); } ");
                break;
            }
            case "boolean": {
                m.setBody("{ return de.mobilej.ABridge.callBoolean(\"" + signature + "\", " + thiz + ", $args); } ");
                break;
            }
            case "int": {
                m.setBody("{ return de.mobilej.ABridge.callInt(\"" + signature + "\", " + thiz + ", $args); } ");
                break;
            }
            case "long": {
                m.setBody("{ return de.mobilej.ABridge.callLong(\"" + signature + "\", " + thiz + ", $args); } ");
                break;
            }
            case "byte": {
                m.setBody("{ return de.mobilej.ABridge.callByte(\"" + signature + "\", " + thiz + ", $args); } ");
                break;
            }
            case "float": {
                m.setBody("{ return de.mobilej.ABridge.callFloat(\"" + signature + "\", " + thiz + ", $args); } ");
                break;
            }
            case "double": {
                m.setBody("{ return de.mobilej.ABridge.callDouble(\"" + signature + "\", " + thiz + ", $args); } ");
                break;
            }
            default: {
                m.setBody("{ return ($r)de.mobilej.ABridge.callObject(\"" + signature + "\"," + thiz + ", $args); } ");
            }
        }
    }

    private static void process(CtClass clazz, List<ClassMapping> classMappings) throws Exception {
        if (clazz.isInterface()) {
            return;
        }
        clazz.defrost();
        clazz.setModifiers(clazz.getModifiers() | 1);
        clazz.setModifiers(clazz.getModifiers() & 0xFFFFFFEF);
        clazz.setModifiers(clazz.getModifiers() & 0xFFFFFFFD);
        clazz.setModifiers(clazz.getModifiers() & 0xFFFFFFFB);
        CtMethod[] methods = clazz.getDeclaredMethods();
        for (CtMethod m : methods) {
            if ((m.getModifiers() & 0x100) == 256) {
                ProcessRealAndroidJar.delegateMethod(m);
            } else {
                ProcessRealAndroidJar.instumentMethod(m);
            }
            m.setModifiers(m.getModifiers() | 1);
            m.setModifiers(m.getModifiers() & 0xFFFFFFEF);
            m.setModifiers(m.getModifiers() & 0xFFFFFFFD);
            m.setModifiers(m.getModifiers() & 0xFFFFFFFB);
            m.setModifiers(m.getModifiers() & 0xFFFFFEFF);
        }
        for (ClassMapping mapping : classMappings) {
            clazz.replaceClassName(mapping.from, mapping.to);
        }
    }

    private static void instumentMethod(CtMethod m) throws CannotCompileException {
        m.instrument(new ExprEditor(){

            public void edit(MethodCall m) throws CannotCompileException {
                if (m.getClassName().equals("java.lang.System") && m.getMethodName().equals("arraycopy")) {
                    m.replace("{java.lang.System.arraycopy($1,$2,$3,$4,$5);}");
                } else if (m.getClassName().equals("dalvik.system.VMRuntime") && m.getMethodName().equals("newUnpaddedArray")) {
                    m.replace("{$_ = java.lang.reflect.Array.newInstance($1,$2);}");
                } else if (m.getClassName().equals("dalvik.system.VMRuntime") && m.getMethodName().equals("getRuntime")) {
                    m.replace("{$_ = null;}");
                }
            }
        });
    }

    public static boolean delete(File file) {
        File[] flist = null;
        if (file == null) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        if (!file.isDirectory()) {
            return false;
        }
        flist = file.listFiles();
        if (flist != null && flist.length > 0) {
            for (File f : flist) {
                if (ProcessRealAndroidJar.delete(f)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static class ClassMapping {
        public final String from;
        public final String to;

        public ClassMapping(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }
}

