/*
 * Decompiled with CFR 0.152.
 */
package com.github.blagerweij.sessionlock;

import com.github.blagerweij.sessionlock.SessionLockService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.LockException;
import liquibase.lockservice.DatabaseChangeLogLock;

public class MySQLLockService
extends SessionLockService {
    static final String SQL_GET_LOCK = "SELECT get_lock(?, ?)";
    static final String SQL_RELEASE_LOCK = "SELECT release_lock(?)";
    static final String SQL_LOCK_INFO = "SELECT l.processlist_id, p.host, p.time, p.state FROM (SELECT is_used_lock(?) AS processlist_id) AS l LEFT JOIN information_schema.processlist p ON p.id = l.processlist_id";

    @Override
    public boolean supports(Database database) {
        return database instanceof MySQLDatabase;
    }

    private String getChangeLogLockName() {
        return (this.database.getDefaultSchemaName() + "." + this.database.getDatabaseChangeLogLockTableName()).toUpperCase(Locale.ROOT);
    }

    private static Integer getIntegerResult(PreparedStatement stmt) throws SQLException {
        try (ResultSet rs = stmt.executeQuery();){
            rs.next();
            Number locked = (Number)rs.getObject(1);
            Integer n = locked == null ? null : Integer.valueOf(locked.intValue());
            return n;
        }
    }

    @Override
    protected boolean acquireLock(Connection con) throws SQLException, LockException {
        try (PreparedStatement stmt = con.prepareStatement(SQL_GET_LOCK);){
            stmt.setString(1, this.getChangeLogLockName());
            int timeoutSeconds = 5;
            stmt.setInt(2, 5);
            Integer locked = MySQLLockService.getIntegerResult(stmt);
            if (locked == null) {
                throw new LockException("GET_LOCK() returned NULL");
            }
            if (locked == 0) {
                boolean bl = false;
                return bl;
            }
            if (locked != 1) {
                throw new LockException("GET_LOCK() returned " + locked);
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    protected void releaseLock(Connection con) throws SQLException, LockException {
        try (PreparedStatement stmt = con.prepareStatement(SQL_RELEASE_LOCK);){
            stmt.setString(1, this.getChangeLogLockName());
            Integer unlocked = MySQLLockService.getIntegerResult(stmt);
            if (!Integer.valueOf(1).equals(unlocked)) {
                throw new LockException("RELEASE_LOCK() returned " + String.valueOf(unlocked).toUpperCase(Locale.ROOT));
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected DatabaseChangeLogLock usedLock(Connection con) throws SQLException, LockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String lockedBy(ResultSet rs) throws SQLException {
        String host = rs.getString("HOST");
        if (host == null) {
            return "connection_id#" + rs.getLong("PROCESSLIST_ID");
        }
        int colonIndex = host.lastIndexOf(58);
        if (colonIndex > 0) {
            host = host.substring(0, colonIndex);
        }
        return host + " (" + rs.getString("STATE") + ")";
    }
}

