/*
 * Decompiled with CFR 0.152.
 */
package com.github.blagerweij.sessionlock;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LockException;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.LockService;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;

public abstract class SessionLockService
implements LockService {
    protected long changeLogLockWaitTime = 5L;
    protected long changeLogLockRecheckTime = 5L;
    protected boolean hasChangeLogLock;
    protected Database database;
    private static final LogSupplier LOG_SUPPLIER;

    public int getPriority() {
        return 2;
    }

    public void setChangeLogLockWaitTime(long changeLogLockWaitTime) {
        this.changeLogLockWaitTime = changeLogLockWaitTime;
    }

    public void setChangeLogLockRecheckTime(long changeLogLocRecheckTime) {
        this.changeLogLockRecheckTime = changeLogLocRecheckTime;
    }

    public boolean supports(Database database) {
        return false;
    }

    public void waitForLock() throws LockException {
        boolean locked = false;
        long timeToGiveUp = new Date().getTime() + this.changeLogLockWaitTime * 1000L * 60L;
        while (!locked && new Date().getTime() < timeToGiveUp) {
            locked = this.acquireLock();
            if (locked) continue;
            SessionLockService.getLog(this.getClass()).info("Waiting for changelog lock....");
            try {
                Thread.sleep(this.changeLogLockRecheckTime * 1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!locked) {
            String lockedBy;
            DatabaseChangeLogLock[] locks = this.listLocks();
            if (locks.length > 0) {
                DatabaseChangeLogLock lock = locks[0];
                lockedBy = lock.getLockedBy() + " since " + DateFormat.getDateTimeInstance(3, 3).format(lock.getLockGranted());
            } else {
                lockedBy = "UNKNOWN";
            }
            throw new LockException("Could not acquire change log lock.  Currently locked by " + lockedBy);
        }
    }

    public void forceReleaseLock() throws LockException {
        try {
            this.releaseLock(this.getConnection());
            SessionLockService.getLog(this.getClass()).info("Successfully force-released change log lock");
        }
        catch (SQLException e) {
            throw new LockException((Throwable)e);
        }
        finally {
            this.hasChangeLogLock = false;
        }
    }

    public void reset() {
        this.hasChangeLogLock = false;
    }

    public void destroy() {
        this.reset();
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public void init() {
    }

    private Connection getConnection() throws LockException {
        DatabaseConnection dbCon = this.database.getConnection();
        if (dbCon instanceof JdbcConnection) {
            return ((JdbcConnection)dbCon).getUnderlyingConnection();
        }
        throw new LockException("Not a JdbcConnection: " + dbCon);
    }

    public boolean acquireLock() throws LockException {
        if (this.hasChangeLogLock) {
            SessionLockService.getLog(this.getClass()).fine("Skipped acquiring of already existing change log lock");
            return true;
        }
        try {
            if (this.acquireLock(this.getConnection())) {
                this.hasChangeLogLock = true;
                SessionLockService.getLog(this.getClass()).info("Successfully acquired change log lock");
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new LockException((Throwable)e);
        }
    }

    protected abstract boolean acquireLock(Connection var1) throws SQLException, LockException;

    public void releaseLock() throws LockException {
        if (!this.hasChangeLogLock) {
            SessionLockService.getLog(this.getClass()).fine("Skipped releasing of nonexistent change log lock");
            return;
        }
        try {
            this.releaseLock(this.getConnection());
            SessionLockService.getLog(this.getClass()).info("Successfully released change log lock");
        }
        catch (SQLException e) {
            throw new LockException((Throwable)e);
        }
        finally {
            this.hasChangeLogLock = false;
        }
    }

    protected abstract void releaseLock(Connection var1) throws SQLException, LockException;

    public DatabaseChangeLogLock[] listLocks() throws LockException {
        try {
            DatabaseChangeLogLock[] databaseChangeLogLockArray;
            DatabaseChangeLogLock usedLock = this.usedLock(this.getConnection());
            if (usedLock == null) {
                databaseChangeLogLockArray = new DatabaseChangeLogLock[]{};
            } else {
                DatabaseChangeLogLock[] databaseChangeLogLockArray2 = new DatabaseChangeLogLock[1];
                databaseChangeLogLockArray = databaseChangeLogLockArray2;
                databaseChangeLogLockArray2[0] = usedLock;
            }
            return databaseChangeLogLockArray;
        }
        catch (SQLException e) {
            throw new LockException((Throwable)e);
        }
    }

    public boolean hasChangeLogLock() {
        return this.hasChangeLogLock;
    }

    protected DatabaseChangeLogLock usedLock(Connection con) throws SQLException, LockException {
        return null;
    }

    protected static Logger getLog(Class<?> clazz) {
        try {
            return LOG_SUPPLIER.getLog(clazz);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        LogSupplier logSupplier = null;
        try {
            Class<?> scopeClass = Class.forName("liquibase.Scope");
            Method getCurrentScope = scopeClass.getMethod("getCurrentScope", new Class[0]);
            Object scope = getCurrentScope.invoke(null, new Object[0]);
            Method getLog = scope.getClass().getMethod("getLog", Class.class);
            logSupplier = c -> (Logger)getLog.invoke(scope, c);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
            try {
                Class<?> logServiceClass = Class.forName("liquibase.logging.LogService");
                Method getLog = logServiceClass.getMethod("getLog", Class.class);
                logSupplier = c -> (Logger)getLog.invoke(null, c);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                logSupplier = c -> LogFactory.getLogger();
            }
        }
        LOG_SUPPLIER = logSupplier;
    }

    static interface LogSupplier {
        public Logger getLog(Class<?> var1) throws InvocationTargetException, IllegalAccessException;
    }
}

