/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.utils;

import com.bld.commons.utils.types.UpperLowerType;
import org.apache.commons.text.WordUtils;

public class CamelCaseUtils {
    private static final String P_UPPER = "(?=\\p{Upper})";

    public static String reverseCamelCase(String javaField, UpperLowerType upperLowerType) {
        String[] splitJavaFields;
        String dbField = "";
        for (String splitJavaField : splitJavaFields = javaField.split(P_UPPER)) {
            dbField = dbField + splitJavaField + " ";
        }
        dbField = dbField.trim();
        dbField = dbField.replace(" ", "_");
        if (upperLowerType == null) {
            dbField = Character.toUpperCase(dbField.charAt(0)) + dbField.substring(1);
        } else if (UpperLowerType.UPPER.equals((Object)upperLowerType)) {
            dbField = dbField.toUpperCase();
        } else if (UpperLowerType.LOWER.equals((Object)upperLowerType)) {
            dbField = dbField.toLowerCase();
        }
        return dbField;
    }

    public static String camelCase(String tableName, boolean firstCharacterLowerCase) {
        String className = tableName.replace("_", " ");
        className = WordUtils.capitalizeFully((String)className).replace(" ", "");
        if (firstCharacterLowerCase) {
            className = Character.toLowerCase(className.charAt(0)) + className.substring(1);
        }
        return className;
    }

    public static String camelCase(String tableName) {
        return CamelCaseUtils.camelCase(tableName, false);
    }
}

