/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.utils;

import com.bld.commons.utils.types.TimeUnitMeasureType;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateUtils {
    private static final Log logger = LogFactory.getLog(DateUtils.class);
    public static final String PROPS_TIME_ZONE = "spring.jackson.time-zone";
    public static final String ENV_TIME_ZONE = "${spring.jackson.time-zone}";

    public static TimeZone getTimezone(String timezone) {
        return TimeZone.getTimeZone(timezone);
    }

    public static Date calendarToDate(Calendar cal) {
        if (cal != null) {
            return cal.getTime();
        }
        return null;
    }

    public static Calendar dateToCalendar(Date data) {
        Calendar calendario = null;
        if (data != null) {
            calendario = Calendar.getInstance();
            calendario.setTimeInMillis(data.getTime());
        }
        return calendario;
    }

    public static Date currentDate() {
        Calendar calendario = Calendar.getInstance();
        return DateUtils.calendarToDate(DateUtils.resetHour(calendario));
    }

    public static Calendar stringToCalendarDate(String dateString, String dateFormat) {
        Date date = DateUtils.stringToDate(dateString, dateFormat);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.resetHour(calendar);
    }

    public static Date stringToDate(String createTimestamp, String dateFormat) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            Date date = sdf.parse(createTimestamp);
            return date;
        }
        catch (Exception e) {
            logger.error((Object)("error while converting string to Date - input: '" + createTimestamp + "'"), (Throwable)e);
            return null;
        }
    }

    public static Date stringToDate(String createTimestamp, String dateFormat, TimeZone timeZone) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            sdf.setTimeZone(timeZone);
            Date date = sdf.parse(createTimestamp);
            return date;
        }
        catch (Exception e) {
            logger.error((Object)("error while converting string to Date - input: '" + createTimestamp + "'"), (Throwable)e);
            return null;
        }
    }

    public static String calendarToString(Calendar cal, String formato) {
        return DateUtils.dateToString(DateUtils.calendarToDate(cal), formato);
    }

    public static String dateToString(Date data, String dateFormat) {
        String dateToString = null;
        if (data != null && StringUtils.isNotBlank((CharSequence)dateFormat)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                dateToString = sdf.format(data.getTime());
            }
            catch (Exception e) {
                logger.error((Object)"error while converting calendar to string", (Throwable)e);
            }
        } else {
            logger.info((Object)("Null Parameter -> date:" + data + ", formato: " + dateFormat));
        }
        return dateToString;
    }

    public static Calendar today() {
        return DateUtils.resetHour(Calendar.getInstance());
    }

    public static Calendar resetHour(Calendar cal) {
        if (cal == null) {
            return null;
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Date resetHour(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.dateToCalendar(date);
        cal = DateUtils.resetHour(cal);
        return DateUtils.calendarToDate(cal);
    }

    public static Long differneceDate(Calendar maxDate, Calendar minDate, TimeUnitMeasureType timeUnitMeasureType) {
        if (maxDate != null && minDate != null) {
            maxDate = DateUtils.resetHour(maxDate);
            minDate = DateUtils.resetHour(minDate);
            long giorni = (maxDate.getTime().getTime() - minDate.getTime().getTime()) / timeUnitMeasureType.getTime();
            return giorni;
        }
        return null;
    }

    public static Long differneceDate(Date maxDate, Date minDate, TimeUnitMeasureType timeUnitMeasureType) {
        if (maxDate != null && minDate != null) {
            return DateUtils.differneceDate(DateUtils.dateToCalendar(maxDate), DateUtils.dateToCalendar(minDate), timeUnitMeasureType);
        }
        return null;
    }

    public static int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    public static Date sumDate(Date date, int year, int month, int week, int day, int hour, int minute, int second) {
        Calendar calendar = DateUtils.sumDate(DateUtils.dateToCalendar(date), year, month, week, day, hour, minute, second);
        if (calendar != null) {
            date = calendar.getTime();
        }
        return date;
    }

    public static Timestamp sumDate(Timestamp timestamp, int year, int month, int week, int day, int hour, int minute, int second) {
        Date date = DateUtils.sumDate(DateUtils.timestampToDate(timestamp), year, month, week, day, hour, minute, second);
        timestamp = DateUtils.dateToTimestamp(date);
        return timestamp;
    }

    public static Date sumDate(Date date, int year, int month, int week, int day) {
        return DateUtils.sumDate(date, year, month, week, day, 0, 0, 0);
    }

    public static Calendar sumDate(Calendar calendar, int year, int month, int week, int day) {
        return DateUtils.sumDate(calendar, year, month, week, day, 0, 0, 0);
    }

    public static Calendar sumDate(Calendar calendar, int year, int month, int week, int day, int hour, int minute, int second) {
        if (calendar != null) {
            calendar.add(1, year);
            calendar.add(2, month);
            calendar.add(5, week * 7 + day);
            calendar.add(10, hour);
            calendar.add(12, minute);
            calendar.add(13, second);
        }
        return calendar;
    }

    public static Timestamp dateToTimestamp(Date date) {
        Timestamp timestamp = null;
        if (date != null) {
            timestamp = new Timestamp(date.getTime());
        }
        return timestamp;
    }

    public static Timestamp now() {
        return new Timestamp(new Date().getTime());
    }

    public static Date timestampToDate(Timestamp timestamp) {
        Date date = null;
        if (timestamp != null) {
            date = new Date(timestamp.getTime());
        }
        return date;
    }

    public static Integer getYear(Calendar date) {
        Integer year = null;
        if (date != null) {
            year = date.get(1);
        }
        return year;
    }

    public static Integer getMonth(Calendar date) {
        Integer month = null;
        if (date != null) {
            month = date.get(2);
        }
        return month;
    }

    public static Integer getDayOfMonth(Calendar date) {
        Integer day = null;
        if (date != null) {
            day = date.get(5);
        }
        return day;
    }

    public static Integer getYear(Date date) {
        return DateUtils.getYear(DateUtils.dateToCalendar(date));
    }

    public static Integer getMonth(Date date) {
        return DateUtils.getMonth(DateUtils.dateToCalendar(date));
    }

    public static Integer getDayOfMonth(Date date) {
        return DateUtils.getDayOfMonth(DateUtils.dateToCalendar(date));
    }
}

