/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.utils.json.annotations.deserialize;

import com.bld.commons.utils.DateUtils;
import com.bld.commons.utils.json.annotations.DateChange;
import com.bld.commons.utils.json.annotations.DateTimeZone;
import com.bld.commons.utils.json.annotations.deserialize.data.DateChangeDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.security.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.AbstractEnvironment;

@JacksonStdImpl
public class DateDeserializer<T>
extends StdScalarDeserializer<T>
implements ContextualDeserializer {
    @Autowired
    private AbstractEnvironment env;
    private DateChangeDeserializer dateFilterDeserializer = null;
    private SimpleDateFormat simpleDateFormat = null;

    public DateDeserializer() {
        super(Object.class);
    }

    private DateDeserializer(Class<T> classDate, DateChangeDeserializer dateDeserializer, SimpleDateFormat simpleDateFormat, AbstractEnvironment env) {
        super(classDate);
        this.dateFilterDeserializer = dateDeserializer;
        this.simpleDateFormat = simpleDateFormat;
        this.env = env;
    }

    protected Date getDate(String dateString) {
        try {
            Date date = this.simpleDateFormat.parse(dateString);
            return DateUtils.sumDate(date, this.dateFilterDeserializer.getAddYear(), this.dateFilterDeserializer.getAddMonth(), this.dateFilterDeserializer.getAddWeek(), this.dateFilterDeserializer.getAddDay(), this.dateFilterDeserializer.getAddHour(), this.dateFilterDeserializer.getAddMinute(), this.dateFilterDeserializer.getAddSecond());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private void setSimpleDateFormat(TimeZone timeZone, String format) {
        this.simpleDateFormat = new SimpleDateFormat(format);
        this.simpleDateFormat.setTimeZone(timeZone);
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String dateString = p.getText();
        Comparable<Date> value = null;
        Date date = this.getDate(dateString);
        if (Date.class.isAssignableFrom(this._valueClass)) {
            value = date;
        }
        if (Calendar.class.isAssignableFrom(this._valueClass)) {
            value = DateUtils.dateToCalendar(date);
        }
        if (Timestamp.class.isAssignableFrom(this._valueClass)) {
            value = DateUtils.dateToTimestamp(date);
        }
        return (T)value;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        DateTimeZone dateTimeZone = (DateTimeZone)property.getAnnotation(DateTimeZone.class);
        DateChange dateFilter = (DateChange)property.getAnnotation(DateChange.class);
        this.dateFilter(dateTimeZone, dateFilter);
        if (property.getType() != null && property.getType().getRawClass() != null) {
            return new DateDeserializer<T>(property.getType().getRawClass(), this.dateFilterDeserializer, this.simpleDateFormat, this.env);
        }
        return this;
    }

    private void dateFilter(DateTimeZone dateTimeZone, DateChange dateFilter) {
        if (dateTimeZone != null) {
            this.dateFilterDeserializer = new DateChangeDeserializer(dateTimeZone.timeZone(), dateTimeZone.format());
        } else if (dateFilter != null) {
            this.dateFilterDeserializer = new DateChangeDeserializer(dateFilter.timeZone(), dateFilter.format(), dateFilter.addYear(), dateFilter.addMonth(), dateFilter.addWeek(), dateFilter.addDay(), dateFilter.addHour(), dateFilter.addMinute(), dateFilter.addSecond());
        }
        if (this.dateFilterDeserializer.getTimeZone().startsWith("${") && this.dateFilterDeserializer.getTimeZone().endsWith("}")) {
            TimeZone timeZone = TimeZone.getDefault();
            String tz = this.env.resolvePlaceholders(this.dateFilterDeserializer.getTimeZone());
            if (StringUtils.isNotBlank((CharSequence)tz) && !tz.equals(this.dateFilterDeserializer.getTimeZone())) {
                timeZone = TimeZone.getTimeZone(tz);
            }
            this.setSimpleDateFormat(timeZone, this.dateFilterDeserializer.getFormat());
        } else {
            this.setSimpleDateFormat(TimeZone.getTimeZone(this.dateFilterDeserializer.getTimeZone()), this.dateFilterDeserializer.getFormat());
        }
    }
}

