/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.utils.json.annotations.serialize;

import com.bld.commons.utils.json.annotations.Base64File;
import com.bld.commons.utils.types.MimeType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.util.Base64;

public class Base64FileSerializer
extends StdScalarSerializer<byte[]>
implements ContextualSerializer {
    private MimeType mimeType;

    public Base64FileSerializer() {
        this(null);
    }

    public Base64FileSerializer(Class<byte[]> t) {
        super(t);
    }

    private String fileBase64(byte[] value) {
        String file = Base64.getEncoder().encodeToString(value);
        if (!MimeType.none.equals((Object)this.mimeType)) {
            file = "data:" + this.mimeType.getMimeType() + ";base64," + file;
        }
        return file;
    }

    public void serialize(byte[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(this.fileBase64(value));
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        Base64File jsonFile = (Base64File)property.getAnnotation(Base64File.class);
        this.mimeType = jsonFile.mimeType();
        return this;
    }
}

