/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.utils.validator;

import com.bld.commons.utils.validator.AllowedValueValidator;
import com.bld.commons.utils.validator.annotations.AllowedNumber;
import jakarta.validation.ConstraintValidatorContext;

public class AllowedNumberValidator
extends AllowedValueValidator<AllowedNumber, Number> {
    private AllowedNumber allowedNumber;

    public void initialize(AllowedNumber allowedNumber) {
        this.allowedNumber = allowedNumber;
    }

    public boolean isValid(Number value, ConstraintValidatorContext context) {
        boolean valid = false;
        if (value != null) {
            double[] dArray = this.allowedNumber.value();
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double checkValue = dArray[i];
                if (checkValue.doubleValue() != value.doubleValue()) continue;
                valid = true;
                break;
            }
        } else {
            valid = true;
        }
        super.setContext(valid, context);
        return valid;
    }

    @Override
    protected String getMessage() {
        CharSequence[] values = new String[this.allowedNumber.value().length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = String.valueOf(this.allowedNumber.value()[i]);
        }
        Object message = this.allowedNumber.message();
        if ("The value is not valid.".equals(message)) {
            message = (String)message + " The values allowed are: " + String.join((CharSequence)",", values);
        }
        return message;
    }
}

