/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.utils.validator;

import com.bld.commons.utils.validator.AllowedValueValidator;
import com.bld.commons.utils.validator.annotations.AllowedString;
import jakarta.validation.ConstraintValidatorContext;

public class AllowedStringValidator
extends AllowedValueValidator<AllowedString, String> {
    protected AllowedString allowedString;

    public void initialize(AllowedString allowedString) {
        this.allowedString = allowedString;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        boolean valid = false;
        if (value != null) {
            for (String v : this.allowedString.value()) {
                if (!v.equals(value)) continue;
                valid = true;
                break;
            }
        } else {
            valid = true;
        }
        super.setContext(valid, context);
        return valid;
    }

    @Override
    protected String getMessage() {
        Object message = this.allowedString.message();
        if ("The value is not valid.".equals(message)) {
            message = (String)message + " The values allowed are: " + String.join((CharSequence)",", this.allowedString.value());
        }
        return message;
    }
}

