/*
 * Decompiled with CFR 0.152.
 */
package com.bld.crypto.jks;

import com.bld.crypto.bean.CryptoKeyUtils;
import com.bld.crypto.jks.config.data.CipherJks;
import com.bld.crypto.type.CryptoType;
import com.bld.crypto.type.InstanceType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.security.Key;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CryptoJksUtils
extends CryptoKeyUtils {
    public static final int SPLIT_STRING = 128;
    public static final String BEARER = "Bearer ";
    @Autowired
    private CipherJks cipherJks;

    public String encryptValue(String value) {
        return super.encryptValue(value, this.cipherJks.getPublicKey());
    }

    public String decryptValue(String value) {
        return super.decryptValue(value, this.cipherJks.getPrivateKey());
    }

    public String encryptObject(Object value) throws JsonProcessingException {
        return super.encryptValue(this.objMapper.writeValueAsString(value), this.cipherJks.getPublicKey());
    }

    public <T> T decryptObject(String value, Class<T> response) throws JsonProcessingException {
        String json = this.decryptValue(value);
        return (T)this.objMapper.readValue(json, response);
    }

    public String encryptUri(String value, CryptoType cryptoType) {
        Key key = this.getEncryptKey(cryptoType);
        String valueEncrypted = this.encryptValue(value, key);
        return this.encodeValue(valueEncrypted);
    }

    public String encryptObjectUri(Object value, CryptoType cryptoType) throws JsonProcessingException {
        return this.encryptUri(this.objMapper.writeValueAsString(value), cryptoType);
    }

    private Key getEncryptKey(CryptoType cryptoType) {
        Key key = this.cipherJks.getPublicKey();
        if (CryptoType.privateKey.equals((Object)cryptoType)) {
            key = this.cipherJks.getPrivateKey();
        }
        return key;
    }

    public String decryptUri(String value, CryptoType cryptoType) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Key key = this.getDecryptKey(cryptoType);
        String decode = new String(Base64.getDecoder().decode(value));
        return this.decryptValue(decode, key);
    }

    private Key getDecryptKey(CryptoType cryptoType) {
        Key key = this.cipherJks.getPrivateKey();
        if (CryptoType.publicKey.equals((Object)cryptoType)) {
            key = this.cipherJks.getPublicKey();
        }
        return key;
    }

    public String decryptValue(String value, CryptoType cryptoType) {
        return super.decryptValue(value, this.getDecryptKey(cryptoType));
    }

    public String encryptValue(String value, CryptoType cryptoType) {
        return super.encryptValue(value, this.getEncryptKey(cryptoType));
    }

    public <T> T decryptObject(String value, Class<T> response, CryptoType cryptoType) throws JsonProcessingException {
        String json = this.decryptValue(value, cryptoType);
        return (T)this.objMapper.readValue(json, response);
    }

    public String encryptObject(Object value, CryptoType cryptoType) throws JsonProcessingException {
        return this.encryptValue(this.objMapper.writeValueAsString(value), cryptoType);
    }

    public String encryptUri(String value) {
        return super.encryptUri(value, null);
    }

    public String encryptObjectUri(Object value) throws JsonProcessingException {
        return super.encryptUri(this.objMapper.writeValueAsString(value), null);
    }

    public String decryptUri(String value) {
        return super.decryptUri(value, null);
    }

    public <T> T decryptObjectUri(String value, Class<T> response) throws JsonMappingException, JsonProcessingException {
        String json = this.decryptUri(value);
        return (T)this.objMapper.readValue(json, response);
    }

    @Override
    protected String encryptValue(String value, String key) {
        return this.encryptValue(value);
    }

    @Override
    protected String decryptValue(String value, String key) {
        return this.decryptValue(value);
    }

    @Override
    protected InstanceType instanceType() {
        return InstanceType.RSA;
    }
}

