/*
 * Decompiled with CFR 0.152.
 */
package com.bld.crypto.jks.deserializer;

import com.bld.crypto.deserializer.DecryptCertificateDeserializer;
import com.bld.crypto.jks.CryptoJksUtils;
import com.bld.crypto.jks.annotation.CryptoJks;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;

@JacksonStdImpl
public class DecryptJksDeserializer<T>
extends DecryptCertificateDeserializer<T>
implements ContextualDeserializer {
    private CryptoJks crypto;
    @Autowired
    private CryptoJksUtils cryptoJksUtils;

    public DecryptJksDeserializer() {
        super(Object.class);
    }

    private DecryptJksDeserializer(JavaType javaType, CryptoJks crypto, CryptoJksUtils cryptoJksUtils, ObjectMapper objMapper) {
        super(javaType, objMapper);
        this.init(crypto, cryptoJksUtils);
    }

    private void init(CryptoJks crypto, CryptoJksUtils cryptoJksUtils) {
        this.crypto = crypto;
        this.cryptoJksUtils = cryptoJksUtils;
    }

    private DecryptJksDeserializer(JavaType javaType, Class<?> classListType, CryptoJks crypto, CryptoJksUtils cryptoJksUtils, ObjectMapper objMapper) {
        super(javaType, classListType, objMapper);
        this.init(crypto, cryptoJksUtils);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JavaType type;
        this.crypto = (CryptoJks)property.getAnnotation(CryptoJks.class);
        JavaType javaType = type = ctxt.getContextualType() != null ? ctxt.getContextualType() : property.getMember().getType();
        if (property.getType() != null && property.getType().getRawClass() != null) {
            if (Collection.class.isAssignableFrom(property.getType().getRawClass())) {
                return new DecryptJksDeserializer<T>(type, type.getContentType().getRawClass(), this.crypto, this.cryptoJksUtils, this.objMapper);
            }
            return new DecryptJksDeserializer<T>(property.getType(), this.crypto, this.cryptoJksUtils, this.objMapper);
        }
        return this;
    }

    @Override
    protected String decrypt(String word) {
        word = this.crypto.url() ? this.cryptoJksUtils.decryptUri(word, this.crypto.decrypt()) : this.cryptoJksUtils.decryptValue(word, this.crypto.decrypt());
        return word;
    }
}

