/*
 * Decompiled with CFR 0.152.
 */
package com.bld.crypto.pubkey;

import com.bld.crypto.bean.CryptoKeyUtils;
import com.bld.crypto.pubkey.config.data.CipherPublicKeys;
import com.bld.crypto.type.InstanceType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CryptoPublicKeyUtils
extends CryptoKeyUtils {
    @Autowired
    private CipherPublicKeys cipherPublicKeys;

    @Override
    public String encryptValue(String value, String key) {
        return super.encryptValue(value, this.cipherPublicKeys.getPublicKey(key));
    }

    public String encryptObject(Object value, String key) throws JsonProcessingException {
        return this.encryptValue(this.objMapper.writeValueAsString(value), key);
    }

    @Override
    public String decryptValue(String value, String key) {
        return super.decryptValue(value, this.cipherPublicKeys.getPublicKey(key));
    }

    public <T> T decryptObject(String value, Class<T> response, String key) throws JsonMappingException, JsonProcessingException {
        String json = this.decryptValue(value, key);
        return (T)this.objMapper.readValue(json, response);
    }

    @Override
    public String encryptUri(String value, String key) {
        return super.encryptUri(value, key);
    }

    public String encryptObjectUri(Object value, String key) throws JsonProcessingException {
        return this.encryptUri(this.objMapper.writeValueAsString(value), key);
    }

    @Override
    public String decryptUri(String value, String key) {
        return super.decryptUri(value, key);
    }

    public <T> T decryptObjectUri(String value, Class<T> response, String key) throws JsonMappingException, JsonProcessingException {
        String json = this.decryptUri(value, key);
        return (T)this.objMapper.readValue(json, response);
    }

    @Override
    protected InstanceType instanceType() {
        return InstanceType.RSA;
    }
}

