/*
 * Decompiled with CFR 0.152.
 */
package com.bld.crypto.pubkey.deserializer;

import com.bld.crypto.bean.CryptoKeyData;
import com.bld.crypto.deserializer.DecryptCertificateDeserializer;
import com.bld.crypto.pubkey.CryptoPublicKeyUtils;
import com.bld.crypto.pubkey.annotations.CryptoPubKey;
import com.bld.crypto.pubkey.annotations.DecryptPubKey;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;

@JacksonStdImpl
public class DecryptPubKeyDeserializer<T>
extends DecryptCertificateDeserializer<T>
implements ContextualDeserializer {
    private CryptoKeyData cryptoPubKey;
    @Autowired
    private CryptoPublicKeyUtils cryptoPubKeyUtils;

    public DecryptPubKeyDeserializer() {
        super(Object.class);
    }

    private DecryptPubKeyDeserializer(JavaType javaType, CryptoKeyData cryptoPubKey, CryptoPublicKeyUtils cryptoPubKeyUtils, ObjectMapper objMapper) {
        super(javaType, objMapper);
        this.init(cryptoPubKey, cryptoPubKeyUtils);
    }

    private DecryptPubKeyDeserializer(JavaType javaType, Class<?> classListType, CryptoKeyData cryptoPubKey, CryptoPublicKeyUtils cryptoPubKeyUtils, ObjectMapper objMapper) {
        super(javaType, classListType, objMapper);
        this.init(cryptoPubKey, cryptoPubKeyUtils);
    }

    private void init(CryptoKeyData cryptoPubKey, CryptoPublicKeyUtils cryptoPubKeyUtils) {
        this.cryptoPubKey = cryptoPubKey;
        this.cryptoPubKeyUtils = cryptoPubKeyUtils;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JavaType type;
        CryptoKeyData cryptoPubKeyData = null;
        if (property.getAnnotation(CryptoPubKey.class) != null) {
            CryptoPubKey cryptoPubKey = (CryptoPubKey)property.getAnnotation(CryptoPubKey.class);
            cryptoPubKeyData = new CryptoKeyData(cryptoPubKey.value(), cryptoPubKey.url());
        } else if (property.getAnnotation(DecryptPubKey.class) != null) {
            DecryptPubKey decryptPubKey = (DecryptPubKey)property.getAnnotation(DecryptPubKey.class);
            cryptoPubKeyData = new CryptoKeyData(decryptPubKey.value(), decryptPubKey.url());
        }
        JavaType javaType = type = ctxt.getContextualType() != null ? ctxt.getContextualType() : property.getMember().getType();
        if (property.getType() != null && property.getType().getRawClass() != null) {
            if (Collection.class.isAssignableFrom(property.getType().getRawClass())) {
                return new DecryptPubKeyDeserializer<T>(type, type.getContentType().getRawClass(), cryptoPubKeyData, this.cryptoPubKeyUtils, this.objMapper);
            }
            return new DecryptPubKeyDeserializer<T>(property.getType(), cryptoPubKeyData, this.cryptoPubKeyUtils, this.objMapper);
        }
        return this;
    }

    @Override
    protected String decrypt(String word) {
        word = this.cryptoPubKey.isUrl() ? this.cryptoPubKeyUtils.decryptUri(word, this.cryptoPubKey.getName()) : this.cryptoPubKeyUtils.decryptValue(word, this.cryptoPubKey.getName());
        return word;
    }
}

