/*
 * Decompiled with CFR 0.152.
 */
package com.bld.crypto.bean;

import com.bld.crypto.exception.CryptoException;
import com.bld.crypto.type.InstanceType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CryptoKeyUtils {
    protected static final String _252F = "_252F25_";
    protected static final String _2F = "%2F";
    private static final Logger logger = LoggerFactory.getLogger(CryptoKeyUtils.class);
    @Autowired
    protected ObjectMapper objMapper;

    protected abstract InstanceType instanceType();

    protected Cipher getCipher(int mode, Key key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(this.instanceType().name());
        cipher.init(mode, key);
        return cipher;
    }

    public String encryptValue(String value, Key key) {
        String valueEncrypted = null;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            try {
                Cipher cipher = this.getCipher(1, key);
                byte[] encrypt = cipher.doFinal(value.getBytes());
                valueEncrypted = Base64.getEncoder().encodeToString(encrypt);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw new CryptoException(e);
            }
        }
        return valueEncrypted;
    }

    public String decryptValue(String value, Key key) {
        String valueDecripted = null;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            try {
                Cipher cipher = this.getCipher(2, key);
                byte[] decrypt = Base64.getDecoder().decode(value);
                valueDecripted = new String(cipher.doFinal(decrypt));
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw new CryptoException(e);
            }
        }
        return valueDecripted;
    }

    protected abstract String encryptValue(String var1, String var2);

    protected abstract String decryptValue(String var1, String var2);

    protected String encryptUri(String value, String key) {
        String valueEncrypted = this.encryptValue(value, key);
        return this.encodeValue(valueEncrypted);
    }

    protected String encodeValue(String valueEncrypted) {
        if (StringUtils.isNotEmpty((CharSequence)valueEncrypted)) {
            return Base64.getEncoder().encodeToString(valueEncrypted.getBytes());
        }
        return null;
    }

    protected String decryptUri(String value, String key) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        String decode = new String(Base64.getDecoder().decode(value));
        return this.decryptValue(decode, key);
    }
}

