/*
 * Decompiled with CFR 0.152.
 */
package com.bld.crypto.pubkey.config;

import com.bld.crypto.exception.CryptoException;
import com.bld.crypto.pubkey.config.PubKeyConditional;
import com.bld.crypto.pubkey.config.data.CipherPublicKeys;
import com.bld.crypto.pubkey.config.data.PublicKeyProperties;
import com.bld.crypto.type.InstanceType;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Conditional(value={PubKeyConditional.class})
@ComponentScan(basePackages={"com.bld.crypto.pubkey", "com.bld.crypto.bean"})
public class CryptoPublicKeyConfiguration
implements WebMvcConfigurer {
    @Autowired
    private PublicKeyProperties publicKeyProps;

    @Bean
    CipherPublicKeys cipherPublicKeys() throws Exception {
        HashMap<String, PublicKey> map = new HashMap<String, PublicKey>();
        for (Map.Entry<String, Resource> key : this.publicKeyProps.getKeys().entrySet()) {
            KeyFactory factory = KeyFactory.getInstance(InstanceType.RSA.name());
            InputStreamReader reader = new InputStreamReader(key.getValue().getInputStream());
            PemReader pemReader = new PemReader((Reader)reader);
            PemObject pemObject = pemReader.readPemObject();
            byte[] content = pemObject.getContent();
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(content);
            PublicKey publicKey = factory.generatePublic(pubKeySpec);
            map.put(key.getKey(), publicKey);
        }
        if (MapUtils.isEmpty(map)) {
            throw new CryptoException("The public keys is empty");
        }
        return new CipherPublicKeys(map);
    }
}

