/*
 * Decompiled with CFR 0.152.
 */
package com.bld.crypto.aes.deserializer;

import com.bld.crypto.aes.CryptoAesUtils;
import com.bld.crypto.aes.annotation.CryptoAes;
import com.bld.crypto.bean.CryptoKeyData;
import com.bld.crypto.deserializer.DecryptCertificateDeserializer;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;

@JacksonStdImpl
public class DecryptAesDeserializer<T>
extends DecryptCertificateDeserializer<T>
implements ContextualDeserializer {
    private CryptoKeyData cryptoKeyData;
    @Autowired
    private CryptoAesUtils cryptoAesUtils;

    public DecryptAesDeserializer() {
        super(Object.class);
    }

    private DecryptAesDeserializer(JavaType javaType, CryptoKeyData cryptoKeyData, CryptoAesUtils cryptoAesUtils, ObjectMapper objMapper) {
        super(javaType, objMapper);
        this.init(cryptoKeyData, cryptoAesUtils);
    }

    private DecryptAesDeserializer(JavaType javaType, Class<?> classListType, CryptoKeyData cryptoKeyData, CryptoAesUtils cryptoAesUtils, ObjectMapper objMapper) {
        super(javaType, classListType, objMapper);
        this.init(cryptoKeyData, cryptoAesUtils);
    }

    private void init(CryptoKeyData cryptoKeyData, CryptoAesUtils cryptoAesUtils) {
        this.cryptoKeyData = cryptoKeyData;
        this.cryptoAesUtils = cryptoAesUtils;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JavaType type;
        CryptoAes cryptoAes = (CryptoAes)property.getAnnotation(CryptoAes.class);
        CryptoKeyData cryptoKeyData = new CryptoKeyData(cryptoAes.value(), cryptoAes.url());
        JavaType javaType = type = ctxt.getContextualType() != null ? ctxt.getContextualType() : property.getMember().getType();
        if (property.getType() != null && property.getType().getRawClass() != null) {
            if (Collection.class.isAssignableFrom(property.getType().getRawClass())) {
                return new DecryptAesDeserializer<T>(type, type.getContentType().getRawClass(), cryptoKeyData, this.cryptoAesUtils, this.objMapper);
            }
            return new DecryptAesDeserializer<T>(property.getType(), cryptoKeyData, this.cryptoAesUtils, this.objMapper);
        }
        return this;
    }

    @Override
    protected String decrypt(String word) {
        word = this.cryptoKeyData.isUrl() ? this.cryptoAesUtils.decryptUri(word, this.cryptoKeyData.getName()) : this.cryptoAesUtils.decryptValue(word, this.cryptoKeyData.getName());
        return word;
    }
}

