/*
 * Decompiled with CFR 0.152.
 */
package com.bld.crypto.aes.serializer;

import com.bld.crypto.aes.CryptoAesUtils;
import com.bld.crypto.aes.annotation.CryptoAes;
import com.bld.crypto.bean.CryptoKeyData;
import com.bld.crypto.serializer.EncryptCertificateSerializer;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.springframework.beans.factory.annotation.Autowired;

@JacksonStdImpl
public class EncryptAesSerializer<T>
extends EncryptCertificateSerializer<T>
implements ContextualSerializer {
    private CryptoKeyData cryptoKeyData;
    @Autowired
    private CryptoAesUtils cryptoAesUtils;

    public EncryptAesSerializer() {
        this((Class<T>)null, (CryptoKeyData)null);
    }

    private EncryptAesSerializer(Class<T> t, CryptoKeyData cryptoKeyData) {
        super(t);
        this.cryptoKeyData = cryptoKeyData;
    }

    private EncryptAesSerializer(Class<T> t, CryptoKeyData cryptoKeyData, CryptoAesUtils cryptoAesUtils, ObjectMapper objMapper) {
        super(t, objMapper);
        this.cryptoKeyData = cryptoKeyData;
        this.cryptoAesUtils = cryptoAesUtils;
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        CryptoAes cryptoAes = (CryptoAes)property.getAnnotation(CryptoAes.class);
        CryptoKeyData cryptoKeyData = new CryptoKeyData(cryptoAes.value(), cryptoAes.url());
        if (property.getType() != null && property.getType().getRawClass() != null) {
            return new EncryptAesSerializer<T>(property.getType().getRawClass(), cryptoKeyData, this.cryptoAesUtils, this.objMapper);
        }
        return this;
    }

    @Override
    protected String encryptValue(String word) {
        return this.cryptoKeyData.isUrl() ? this.cryptoAesUtils.encryptUri(word, this.cryptoKeyData.getName()) : this.cryptoAesUtils.encryptValue(word, this.cryptoKeyData.getName());
    }
}

