/*
 * Decompiled with CFR 0.152.
 */
package com.bld.crypto.jks.config;

import com.bld.crypto.jks.config.properties.JksKeyProperties;
import com.bld.crypto.key.JksKey;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"com.bld.crypto.jks.file"})
@ComponentScan(basePackages={"com.bld.crypto.jks", "com.bld.crypto.bean", "com.bld.crypto.key"})
public class CryptoJksConfiguration {
    public static final String CIPHER_JKS_KEY = "cipherJksKey";
    @Autowired
    private JksKeyProperties jksKeyProperties;

    @Bean(value={"cipherJksKey"})
    JksKey cipherJksKey() throws Exception {
        KeyStore store = KeyStore.getInstance(this.jksKeyProperties.getInstanceJks());
        InputStream inputStream = this.jksKeyProperties.getFile().getInputStream();
        char[] password = this.jksKeyProperties.getPassword().toCharArray();
        store.load(inputStream, password);
        PrivateKey privateKey = (PrivateKey)store.getKey(this.jksKeyProperties.getAlias(), password);
        Certificate cert = store.getCertificate(this.jksKeyProperties.getAlias());
        PublicKey publicKey = cert.getPublicKey();
        return new JksKey(privateKey, publicKey);
    }
}

