/*
 * Decompiled with CFR 0.152.
 */
package com.bld.crypto.pubkey.formatter;

import com.bld.crypto.pubkey.CryptoPublicKeyUtils;
import com.bld.crypto.pubkey.annotations.CryptoPubKey;
import com.bld.crypto.pubkey.formatter.CryptoPubKeyFormatter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Parser;
import org.springframework.format.Printer;

public final class CryptoPubKeyAnnotationFormatterFactory
implements AnnotationFormatterFactory<CryptoPubKey> {
    private static final Set<Class<?>> FIELD_TYPES = new HashSet<Class>(Arrays.asList(String.class, Number.class));
    private CryptoPublicKeyUtils cryptoPubKeyUtils;
    private ObjectMapper objMapper;

    public CryptoPubKeyAnnotationFormatterFactory(CryptoPublicKeyUtils cryptoPubKeyUtils, ObjectMapper objMapper) {
        this.cryptoPubKeyUtils = cryptoPubKeyUtils;
        this.objMapper = objMapper;
    }

    public Set<Class<?>> getFieldTypes() {
        return FIELD_TYPES;
    }

    public Printer<?> getPrinter(CryptoPubKey annotation, Class<?> fieldType) {
        return new CryptoPubKeyFormatter(this.objMapper, fieldType, annotation, this.cryptoPubKeyUtils);
    }

    public Parser<?> getParser(CryptoPubKey annotation, Class<?> fieldType) {
        return new CryptoPubKeyFormatter(this.objMapper, fieldType, annotation, this.cryptoPubKeyUtils);
    }
}

