/*
 * Decompiled with CFR 0.152.
 */
package com.bld.crypto.pubkey.serializer;

import com.bld.crypto.bean.CryptoKeyData;
import com.bld.crypto.pubkey.CryptoPublicKeyUtils;
import com.bld.crypto.pubkey.annotations.CryptoPubKey;
import com.bld.crypto.pubkey.annotations.EncryptPubKey;
import com.bld.crypto.serializer.EncryptCertificateSerializer;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.springframework.beans.factory.annotation.Autowired;

@JacksonStdImpl
public class EncryptPubKeySerializer<T>
extends EncryptCertificateSerializer<T>
implements ContextualSerializer {
    private CryptoKeyData cryptoPubKey;
    @Autowired
    private CryptoPublicKeyUtils cryptoPublicKeyUtils;

    public EncryptPubKeySerializer() {
        this((Class<T>)null, (CryptoKeyData)null);
    }

    private EncryptPubKeySerializer(Class<T> t, CryptoKeyData cryptoPubKey) {
        super(t);
        this.cryptoPubKey = cryptoPubKey;
    }

    private EncryptPubKeySerializer(Class<T> t, CryptoKeyData cryptoPubKey, CryptoPublicKeyUtils cryptoPublicKeyUtils, ObjectMapper objMapper) {
        super(t, objMapper);
        this.cryptoPubKey = cryptoPubKey;
        this.cryptoPublicKeyUtils = cryptoPublicKeyUtils;
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        CryptoKeyData cryptoPubKeyData = null;
        if (property.getAnnotation(CryptoPubKey.class) != null) {
            CryptoPubKey cryptoPubKey = (CryptoPubKey)property.getAnnotation(CryptoPubKey.class);
            cryptoPubKeyData = new CryptoKeyData(cryptoPubKey.value(), cryptoPubKey.url());
        } else if (property.getAnnotation(EncryptPubKey.class) != null) {
            EncryptPubKey encryptPubKey = (EncryptPubKey)property.getAnnotation(EncryptPubKey.class);
            cryptoPubKeyData = new CryptoKeyData(encryptPubKey.value(), encryptPubKey.url());
        }
        if (property.getType() != null && property.getType().getRawClass() != null) {
            return new EncryptPubKeySerializer<T>(property.getType().getRawClass(), cryptoPubKeyData, this.cryptoPublicKeyUtils, this.objMapper);
        }
        return this;
    }

    @Override
    protected String encryptValue(String word) {
        return this.cryptoPubKey.isUrl() ? this.cryptoPublicKeyUtils.encryptUri(word, this.cryptoPubKey.getName()) : this.cryptoPublicKeyUtils.encryptValue(word, this.cryptoPubKey.getName());
    }
}

