/*
 * Decompiled with CFR 0.152.
 */
package com.bld.crypto.deserializer;

import com.bld.crypto.exception.CryptoException;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DecryptCertificateDeserializer<T>
extends StdScalarDeserializer<T> {
    private static final Logger logger = LoggerFactory.getLogger(DecryptCertificateDeserializer.class);
    @Autowired
    protected ObjectMapper objMapper;
    protected Class<T> fieldType;
    protected Class<?> listFieldType;

    protected DecryptCertificateDeserializer(Class<?> t) {
        super(t);
    }

    protected DecryptCertificateDeserializer(JavaType javaType, ObjectMapper objMapper) {
        super(javaType);
        this.fieldType = javaType.getRawClass();
        this.objMapper = objMapper;
    }

    protected DecryptCertificateDeserializer(JavaType javaType, Class<?> listFieldType, ObjectMapper objMapper) {
        this(javaType, objMapper);
        this.listFieldType = listFieldType;
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        Object[] value = null;
        try {
            if (this.isAssignableFrom(Collection.class)) {
                Object[] values;
                List list = (List)this.objMapper.readValue(p, List.class);
                for (int i = 0; i < list.size(); ++i) {
                    Object item = this.getValue(this.decrypt(list.get(i).toString()), this.listFieldType);
                    list.set(i, item);
                }
                String parser = this.objMapper.writeValueAsString((Object)list);
                value = values = (Object[])this.objMapper.readValue(parser, this.fieldType);
            } else if (this.isAssignableFrom(Object[].class)) {
                Object[] values;
                logger.info("is array");
                List<String> list = this.listCrypto(p);
                Object[] objects = new Object[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    objects[i] = this.getValue(this.decrypt(list.get(i).toString()), this.fieldType.getComponentType());
                }
                String parser = this.objMapper.writeValueAsString((Object)objects);
                value = values = (Object[])this.objMapper.readValue(parser, this.fieldType);
            } else {
                String word = p.getText();
                word = this.decrypt(word);
                value = (Object[])this.getValue(word, this.fieldType);
            }
        }
        catch (IllegalArgumentException | SecurityException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CryptoException(e);
        }
        return (T)value;
    }

    private <F> F getValue(String word, Class<F> classField) throws JsonMappingException, JsonProcessingException {
        Object value = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{word})) {
            if (Number.class.isAssignableFrom(classField)) {
                Double number = Double.valueOf(word);
                value = Integer.class.isAssignableFrom(classField) ? (Number)Integer.valueOf(word) : (Number)(BigDecimal.class.isAssignableFrom(classField) ? BigDecimal.valueOf(number) : (BigInteger.class.isAssignableFrom(classField) ? new BigInteger(word) : (Long.class.isAssignableFrom(classField) ? (Number)Long.valueOf(word) : (Number)(Float.class.isAssignableFrom(classField) ? (Number)Float.valueOf(word) : (Number)number))));
            } else {
                value = String.class.isAssignableFrom(classField) ? word : this.objMapper.readValue(word, classField);
            }
        }
        return (F)value;
    }

    private boolean isAssignableFrom(Class<?> classField) {
        return classField.isAssignableFrom(this._valueClass);
    }

    protected abstract String decrypt(String var1);

    private List<String> listCrypto(JsonParser p) throws IOException {
        JsonToken nextValue = p.nextValue();
        ArrayList<String> list = new ArrayList<String>();
        do {
            if (!StringUtils.isNotBlank((CharSequence)p.getText())) continue;
            list.add(p.getText());
        } while ((nextValue = p.nextValue()) != JsonToken.END_ARRAY && nextValue != JsonToken.END_OBJECT);
        return list;
    }
}

