/*
 * Decompiled with CFR 0.152.
 */
package com.bld.crypto.formatter;

import com.bld.crypto.exception.CryptoException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.Formatter;

public abstract class CryptoFormatter<T>
implements Formatter<T> {
    private ObjectMapper objMapper;
    private Class<T> fieldType;
    private static final Logger logger = LoggerFactory.getLogger(CryptoFormatter.class);

    public CryptoFormatter(ObjectMapper objMapper, Class<T> fieldType) {
        this.objMapper = objMapper;
        this.fieldType = fieldType;
    }

    public String print(T value, Locale locale) {
        try {
            if (value != null) {
                if (value instanceof Number || value instanceof String) {
                    return this.encrypt(value);
                }
                return this.encryptValue(this.objMapper.writeValueAsString(value));
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return null;
    }

    public T parse(String text, Locale locale) throws ParseException {
        T value = null;
        try {
            String word = text;
            word = this.decrypt(word);
            value = this.getValue(word, this.fieldType);
        }
        catch (JsonProcessingException | IllegalArgumentException | SecurityException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CryptoException(e);
        }
        return value;
    }

    private <F> F getValue(String word, Class<F> classField) throws JsonMappingException, JsonProcessingException {
        Object value = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{word})) {
            if (Number.class.isAssignableFrom(classField)) {
                Double number = Double.valueOf(word);
                value = Integer.class.isAssignableFrom(classField) ? (Number)Integer.valueOf(word) : (Number)(BigDecimal.class.isAssignableFrom(classField) ? BigDecimal.valueOf(number) : (BigInteger.class.isAssignableFrom(classField) ? new BigInteger(word) : (Long.class.isAssignableFrom(classField) ? (Number)Long.valueOf(word) : (Number)(Float.class.isAssignableFrom(classField) ? (Number)Float.valueOf(word) : (Number)number))));
            } else {
                value = String.class.isAssignableFrom(classField) ? word : this.objMapper.readValue(word, classField);
            }
        }
        return (F)value;
    }

    private String encrypt(T value) {
        String word = value.toString();
        return this.encryptValue(word);
    }

    protected abstract String encryptValue(String var1);

    protected abstract String decrypt(String var1);
}

