/*
 * Decompiled with CFR 0.152.
 */
package com.bld.crypto.jks.serializer;

import com.bld.crypto.jks.CryptoJksUtils;
import com.bld.crypto.jks.annotation.CryptoJks;
import com.bld.crypto.serializer.EncryptCertificateSerializer;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.springframework.beans.factory.annotation.Autowired;

@JacksonStdImpl
public class EncryptJksSerializer<T>
extends EncryptCertificateSerializer<T>
implements ContextualSerializer {
    private CryptoJks crypto;
    @Autowired
    private CryptoJksUtils cryptoJksUtils;

    public EncryptJksSerializer() {
        this((Class<T>)null, (CryptoJks)null);
    }

    private EncryptJksSerializer(Class<T> t, CryptoJks crypto) {
        super(t);
        this.crypto = crypto;
    }

    private EncryptJksSerializer(Class<T> t, CryptoJks crypto, CryptoJksUtils cryptoJksUtils, ObjectMapper objMapper) {
        super(t, objMapper);
        this.crypto = crypto;
        this.cryptoJksUtils = cryptoJksUtils;
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        this.crypto = (CryptoJks)property.getAnnotation(CryptoJks.class);
        if (property.getType() != null && property.getType().getRawClass() != null) {
            return new EncryptJksSerializer<T>(property.getType().getRawClass(), this.crypto, this.cryptoJksUtils, this.objMapper);
        }
        return this;
    }

    @Override
    protected String encryptValue(String word) {
        word = this.crypto.url() ? this.cryptoJksUtils.encryptUri(word, this.crypto.encrypt()) : this.cryptoJksUtils.encryptValue(word, this.crypto.encrypt());
        return word;
    }
}

