/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.reflection.model;

import bld.commons.reflection.model.BaseParameter;
import bld.commons.reflection.model.BaseQueryParameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class QueryParameter<T, ID>
extends BaseQueryParameter<T, ID> {
    private Map<String, Object> parameters;
    private Set<String> nullables;

    public QueryParameter() {
        this.init();
    }

    public QueryParameter(BaseParameter baseParameter) {
        super(baseParameter);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        this.nullables = new HashSet<String>();
        this.parameters = new HashMap<String, Object>();
    }

    public QueryParameter(ID id) {
        super(id);
        this.init();
        this.parameters.put("id", id);
    }

    public Set<String> getNullables() {
        return this.nullables;
    }

    @Override
    public void addParameter(String key, Object value) {
        if (key != null && value != null) {
            this.parameters.put(key, value);
        }
    }

    public void addNullable(String nullable) {
        if (StringUtils.isNotBlank((CharSequence)nullable)) {
            this.nullables.add(nullable);
        }
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

