/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.reflection.model;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfoClass {
    private Class<?> classe;
    private Map<String, List<Method>> mapMethod;
    private List<Method> listMethod;
    private List<Method> listOnlySetMethod;
    private Map<String, Field> mapField;

    public InfoClass(Class<?> classe) {
        this.classe = classe;
        this.listMethod = new ArrayList<Method>();
        this.listOnlySetMethod = new ArrayList<Method>();
        this.mapMethod = new HashMap<String, List<Method>>();
        this.mapField = new HashMap<String, Field>();
        Class<?> classApp = classe;
        do {
            this.setAllInformation(classApp.getMethods(), classApp.getDeclaredFields());
        } while ((classApp = classApp.getSuperclass()).getSuperclass() != null && !classApp.getName().equals(Object.class.getName()));
    }

    private void setAllInformation(Method[] listMethod, Field[] listField) {
        for (Method method : listMethod) {
            if (!this.mapMethod.containsKey(method.getName())) {
                this.mapMethod.put(method.getName(), new ArrayList());
            }
            this.mapMethod.get(method.getName()).add(method);
            this.listMethod.add(method);
            if (!method.getName().startsWith("set")) continue;
            this.listOnlySetMethod.add(method);
        }
        for (AccessibleObject accessibleObject : listField) {
            if (this.mapField.containsKey(((Field)accessibleObject).getName())) continue;
            this.mapField.put(((Field)accessibleObject).getName(), (Field)accessibleObject);
        }
    }

    public Class<?> getClasse() {
        return this.classe;
    }

    public Map<String, List<Method>> getMapMethod() {
        return this.mapMethod;
    }

    public List<Method> getListMethod() {
        return this.listMethod;
    }

    public Map<String, Field> getMapField() {
        return this.mapField;
    }

    public void setClasse(Class<?> classe) {
        this.classe = classe;
    }

    public void setMapMethod(Map<String, List<Method>> mapMethod) {
        this.mapMethod = mapMethod;
    }

    public void setListMethod(List<Method> listMethod) {
        this.listMethod = listMethod;
    }

    public void setMapField(Map<String, Field> mapField) {
        this.mapField = mapField;
    }

    public List<Method> getListOnlySetMethod() {
        return this.listOnlySetMethod;
    }

    public void setListOnlySetMethod(List<Method> lsitOnlySetMethod) {
        this.listOnlySetMethod = lsitOnlySetMethod;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classe == null ? 0 : this.classe.hashCode());
        result = 31 * result + (this.listMethod == null ? 0 : this.listMethod.hashCode());
        result = 31 * result + (this.listOnlySetMethod == null ? 0 : this.listOnlySetMethod.hashCode());
        result = 31 * result + (this.mapField == null ? 0 : this.mapField.hashCode());
        result = 31 * result + (this.mapMethod == null ? 0 : this.mapMethod.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InfoClass other = (InfoClass)obj;
        if (this.classe == null ? other.classe != null : !this.classe.equals(other.classe)) {
            return false;
        }
        if (this.listMethod == null ? other.listMethod != null : !this.listMethod.equals(other.listMethod)) {
            return false;
        }
        if (this.listOnlySetMethod == null ? other.listOnlySetMethod != null : !this.listOnlySetMethod.equals(other.listOnlySetMethod)) {
            return false;
        }
        if (this.mapField == null ? other.mapField != null : !this.mapField.equals(other.mapField)) {
            return false;
        }
        return !(this.mapMethod == null ? other.mapMethod != null : !this.mapMethod.equals(other.mapMethod));
    }
}

