/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.reflection.model;

import bld.commons.reflection.annotations.ConditionsZone;
import bld.commons.reflection.annotations.ConditionsZones;
import bld.commons.reflection.model.BaseParameter;
import bld.commons.reflection.model.BaseQueryParameter;
import bld.commons.reflection.model.ConditionsZoneModel;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NativeQueryParameter<T, ID>
extends BaseQueryParameter<T, ID> {
    private static final String DEFAULT = "default";
    private Class<T> resultClass;
    private Map<String, StringBuilder> emptyZones;
    private Map<String, ConditionsZoneModel> mapConditionsZone;
    private String key;

    public NativeQueryParameter(Class<T> resultClass) {
        this.init();
        this.resultClass = resultClass;
        this.key = DEFAULT;
    }

    public NativeQueryParameter(Class<T> resultClass, BaseParameter filterParameter) {
        super(filterParameter);
        this.init();
        this.resultClass = resultClass;
    }

    public NativeQueryParameter(Class<T> resultClass, ID id) {
        super(id);
        this.init();
        this.resultClass = resultClass;
    }

    public NativeQueryParameter(Class<T> resultClass, Map<String, ConditionsZoneModel> mapConditionsZone) {
        this.init();
        this.resultClass = resultClass;
        this.mapConditionsZone = mapConditionsZone;
    }

    public Class<T> getResultClass() {
        return this.resultClass;
    }

    @Override
    protected void init() {
        super.init();
        this.mapConditionsZone = new HashMap<String, ConditionsZoneModel>();
        this.emptyZones = new HashMap<String, StringBuilder>();
        this.key = DEFAULT;
    }

    private void addParameters(String key, Object value, ConditionsZone zone) {
        if (key != null) {
            if (zone != null) {
                if (!this.mapConditionsZone.containsKey(zone.key())) {
                    this.mapConditionsZone.put(zone.key(), new ConditionsZoneModel(zone));
                }
                this.mapConditionsZone.get(zone.key()).setWhere(zone);
                this.mapConditionsZone.get(zone.key()).addParameter(key, value);
            } else {
                if (!this.mapConditionsZone.containsKey("joinZone")) {
                    this.mapConditionsZone.put("joinZone", new ConditionsZoneModel("joinZone"));
                }
                this.mapConditionsZone.get("joinZone").addParameter(key, value);
            }
        }
    }

    public void addEmptyZones(ConditionsZones conditionsZones) {
        for (ConditionsZone zone : conditionsZones.value()) {
            this.emptyZones.put(zone.key(), new StringBuilder(""));
        }
    }

    public void addParameter(String key, Object value, ConditionsZones conditionsZones) {
        if (conditionsZones == null) {
            this.addParameter(key, value);
        } else {
            for (ConditionsZone conditionsZone : conditionsZones.value()) {
                this.addParameters(key, value, conditionsZone);
            }
        }
    }

    @Override
    public void addParameter(String key, Object value) {
        this.addParameters(key, value, null);
    }

    public void addNullable(String nullable, ConditionsZones zones) {
        if (zones == null) {
            this.addNullable(nullable);
        } else {
            for (ConditionsZone conditionsZone : zones.value()) {
                this.addNullables(nullable, conditionsZone);
            }
        }
    }

    public void addNullable(String nullable) {
        this.addNullables(nullable, null);
    }

    public void addNullables(String nullable, ConditionsZone zone) {
        if (StringUtils.isNotBlank((CharSequence)nullable)) {
            if (zone != null) {
                if (!this.mapConditionsZone.containsKey(zone.key())) {
                    this.mapConditionsZone.put(zone.key(), new ConditionsZoneModel(zone));
                }
                this.mapConditionsZone.get(zone.key()).setWhere(zone);
                this.mapConditionsZone.get(zone.key()).addNullables(nullable);
            } else {
                if (!this.mapConditionsZone.containsKey("joinZone")) {
                    this.mapConditionsZone.put("joinZone", new ConditionsZoneModel("joinZone"));
                }
                this.mapConditionsZone.get("joinZone").addNullables(nullable);
            }
        }
    }

    public Map<String, ConditionsZoneModel> getMapConditionsZone() {
        return this.mapConditionsZone;
    }

    public Map<String, StringBuilder> getEmptyZones() {
        this.emptyZones.remove("joinZone");
        for (String key : this.mapConditionsZone.keySet()) {
            this.emptyZones.remove(key);
        }
        return this.emptyZones;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

