/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.controller;

import com.bld.commons.controller.mapper.ModelMapper;
import com.bld.commons.reflection.model.BaseParameter;
import com.bld.commons.reflection.model.QueryParameter;
import com.bld.commons.service.JpaService;
import com.bld.commons.utils.data.BaseModel;
import com.bld.commons.utils.data.CollectionResponse;
import com.bld.commons.utils.data.ObjectResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class BaseSearchController<E, ID, M extends BaseModel<ID>, P extends BaseParameter, MM extends ModelMapper<E, M>> {
    @Autowired
    protected JpaService<E, ID> jpaService;

    protected CollectionResponse<M> findByFilter(P baseParameter) throws Exception {
        QueryParameter queryFilter = new QueryParameter(baseParameter);
        CollectionResponse response = new CollectionResponse();
        List<E> list = this.jpaService.findByFilter(queryFilter);
        Long totalCount = this.jpaService.countByFilter(queryFilter);
        ArrayList<BaseModel> listModel = new ArrayList<BaseModel>();
        for (E entity : list) {
            BaseModel model = (BaseModel)this.modelMapper().convertToModel(entity);
            listModel.add(model);
        }
        response.setData(listModel);
        response.setTotalCount(totalCount != null ? totalCount : Long.valueOf(0L));
        if (queryFilter.getPageable() != null) {
            response.setPageNumber(Integer.valueOf(queryFilter.getPageable().getPageNumber()));
            response.setPageSize(Integer.valueOf(queryFilter.getPageable().getPageSize()));
        }
        return response;
    }

    protected ObjectResponse<Long> countByFilter(@RequestBody P baseParameter) throws Exception {
        QueryParameter queryFilter = new QueryParameter(baseParameter);
        Long count = this.jpaService.countByFilter(queryFilter);
        return new ObjectResponse((Object)count);
    }

    protected ObjectResponse<M> singleResultFindByFilter(@RequestBody P baseParameter) throws Exception {
        QueryParameter query = new QueryParameter(baseParameter);
        ObjectResponse response = new ObjectResponse();
        E entity = this.jpaService.singleResultByFilter(query);
        response.setData((Object)((BaseModel)this.modelMapper().convertToModel(entity)));
        return response;
    }

    protected abstract MM modelMapper();
}

