/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.reflection.model;

import com.bld.commons.reflection.model.BaseParameter;
import com.bld.commons.reflection.model.OrderBy;
import com.bld.commons.reflection.type.OrderType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public abstract class BaseQueryParameter<T, ID>
implements Serializable {
    public static final String ID = "id";
    private ID id;
    private List<OrderBy> listOrderBy;
    private Pageable pageable;
    private BaseParameter baseParameter;

    protected BaseQueryParameter() {
    }

    protected BaseQueryParameter(ID id) {
        this.id = id;
    }

    protected BaseQueryParameter(BaseParameter baseParameter) {
        this.setBaseParameter(baseParameter);
    }

    public ID getId() {
        return this.id;
    }

    public void setId(ID id) {
        this.id = id;
    }

    protected void init() {
        if (CollectionUtils.isEmpty(this.listOrderBy)) {
            this.listOrderBy = new ArrayList<OrderBy>();
        }
    }

    public List<OrderBy> getListOrderBy() {
        return this.listOrderBy;
    }

    public void setListOrderBy(List<OrderBy> listOrderBy) {
        this.listOrderBy = listOrderBy;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public void setPageable(Pageable pageable) {
        this.pageable = pageable;
    }

    public BaseParameter getBaseParameter() {
        return this.baseParameter;
    }

    public void setBaseParameter(BaseParameter baseParameter) {
        this.baseParameter = baseParameter;
        if (baseParameter != null) {
            if (CollectionUtils.isNotEmpty(baseParameter.getOrderBy())) {
                this.listOrderBy = baseParameter.getOrderBy();
            }
            if (baseParameter.getPageNumber() != null && baseParameter.getPageSize() != null) {
                this.pageable = PageRequest.of((int)baseParameter.getPageNumber(), (int)baseParameter.getPageSize());
            }
        }
    }

    public void setPageable(Integer page, Integer size) {
        if (page != null && size != null) {
            this.pageable = PageRequest.of((int)page, (int)size);
        }
    }

    public void addOrderBy(OrderBy ... listOrderBy) {
        if (ArrayUtils.isNotEmpty((Object[])listOrderBy)) {
            for (OrderBy orderBy : listOrderBy) {
                this.listOrderBy.add(orderBy);
            }
        }
    }

    public void addOrderBy(String field, OrderType ordertType) {
        if (StringUtils.isNotBlank((CharSequence)field)) {
            this.listOrderBy.add(OrderBy.of(field, ordertType));
        }
    }

    public abstract void addParameter(String var1, Object var2);
}

