/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.controller;

import com.bld.commons.controller.BaseSearchController;
import com.bld.commons.controller.mapper.PerformanceModelMapper;
import com.bld.commons.reflection.model.BaseParameter;
import com.bld.commons.reflection.model.QueryParameter;
import com.bld.commons.utils.data.BaseModel;
import com.bld.commons.utils.data.CollectionResponse;
import com.bld.commons.utils.data.ObjectResponse;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class PerformanceSearchController<E, ID, M extends BaseModel<ID>, PM extends BaseModel<ID>, P extends BaseParameter>
extends BaseSearchController<E, ID, M, P, PerformanceModelMapper<E, M, PM>> {
    @Autowired
    private PerformanceModelMapper<E, M, PM> modelMapper;

    @PostMapping(path={"/performance/search"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    @Valid
    @Transactional
    public CollectionResponse<PM> speedUpFindByFilter(@RequestBody P baseParameter) throws Exception {
        QueryParameter queryFilter = new QueryParameter(baseParameter);
        CollectionResponse response = new CollectionResponse();
        List list = this.jpaService.findByFilter(queryFilter);
        Long totalCount = this.jpaService.countByFilter(queryFilter);
        ArrayList listModel = new ArrayList();
        for (Object entity : list) {
            Object model = this.modelMapper().convertToPerformanceModel(entity);
            listModel.add(model);
        }
        response.setData(listModel);
        response.setTotalCount(totalCount != null ? totalCount : Long.valueOf(0L));
        if (queryFilter.getPageable() != null) {
            response.setPageNumber(Integer.valueOf(queryFilter.getPageable().getPageNumber()));
            response.setPageSize(Integer.valueOf(queryFilter.getPageable().getPageSize()));
        }
        return response;
    }

    @Override
    protected PerformanceModelMapper<E, M, PM> modelMapper() {
        return this.modelMapper;
    }

    @Override
    @PostMapping(path={"/search"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    @Valid
    @Transactional
    public CollectionResponse<M> findByFilter(@RequestBody P baseParameter) throws Exception {
        return super.findByFilter(baseParameter);
    }

    @Override
    @PostMapping(path={"/count"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    @Valid
    @Transactional
    public ObjectResponse<Long> countByFilter(@RequestBody P baseParameter) throws Exception {
        return super.countByFilter(baseParameter);
    }

    @Override
    @PostMapping(path={"/search/single-result"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    @Valid
    @Transactional
    public ObjectResponse<M> singleResultFindByFilter(@RequestBody P baseParameter) throws Exception {
        return super.singleResultFindByFilter(baseParameter);
    }
}

